/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.validator.DocumentEditionFormValidator;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form"})
public class DocumentEditionController
implements PortletContextAware {
    private PortletContext portletContext;
    @Autowired
    private DocumentEditionService service;
    @Autowired
    private DocumentEditionFormValidator validator;

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        return this.service.getViewPath(portalControllerContext);
    }

    @ActionMapping(name="submit", params={"upload"})
    public void upload(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.upload(portalControllerContext, form);
    }

    @ActionMapping(name="submit", params={"restore"})
    public void restore(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.restore(portalControllerContext, form);
    }

    @ActionMapping(name="submit", params={"upload-attachments"})
    public void uploadAttachments(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadAttachments(portalControllerContext, form);
    }

    @ActionMapping(name="submit", params={"delete-attachment"})
    public void deleteAttachment(ActionRequest request, ActionResponse response, @RequestParam(value="delete-attachment") String value, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteAttachment(portalControllerContext, form, value);
    }

    @ActionMapping(name="submit", params={"restore-attachment"})
    public void restoreAttachment(ActionRequest request, ActionResponse response, @RequestParam(value="restore-attachment") String value, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.restoreAttachment(portalControllerContext, form, value);
    }

    @ActionMapping(name="submit", params={"upload-picture"})
    public void uploadPicture(ActionRequest request, ActionResponse response, @RequestParam(value="upload-picture") String pictureType, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadPicture(portalControllerContext, form, pictureType);
    }

    @ActionMapping(name="submit", params={"delete-picture"})
    public void deletePicture(ActionRequest request, ActionResponse response, @RequestParam(value="delete-picture") String pictureType, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deletePicture(portalControllerContext, form, pictureType);
    }

    @ActionMapping(name="submit", params={"restore-picture"})
    public void restorePicture(ActionRequest request, ActionResponse response, @RequestParam(value="restore-picture") String pictureType, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.restorePicture(portalControllerContext, form, pictureType);
    }

    @ActionMapping(name="submit", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") AbstractDocumentEditionForm form, BindingResult result, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            sessionStatus.setComplete();
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response, SessionStatus sessionStatus) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        sessionStatus.setComplete();
        this.service.cancel(portalControllerContext);
    }

    @ResourceMapping(value="picture-preview")
    public void picturePreview(ResourceRequest request, ResourceResponse response, @RequestParam(value="type") String pictureType, @ModelAttribute(value="form") AbstractDocumentEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.picturePreview(portalControllerContext, form, pictureType);
    }

    @ResourceMapping(value="editor")
    public void editor(ResourceRequest request, ResourceResponse response, @RequestParam(value="editorId") String editorId) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.serveEditor(portalControllerContext, editorId);
    }

    @ModelAttribute(value="form")
    public AbstractDocumentEditionForm getForm(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void editionFormInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.setDisallowedFields(new String[]{"name", "creation", "path", "originalTitle"});
    }
}

