/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.BlobRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.editor.EditorTemporaryAttachedPicture;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.Attachments;
import org.osivia.services.edition.portlet.model.DocumentEditionMetadata;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.repository.DocumentEditionAttachmentsRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionCommonRepositoryImpl;
import org.osivia.services.edition.portlet.repository.DocumentEditionMetadataRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepository;
import org.osivia.services.edition.portlet.repository.command.CheckTitleAvailabilityCommand;
import org.osivia.services.edition.portlet.repository.command.CreateDocumentCommand;
import org.osivia.services.edition.portlet.repository.command.UpdateDocumentCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.portlet.context.PortletContextAware;

public abstract class DocumentEditionRepositoryImpl<T extends AbstractDocumentEditionForm>
extends DocumentEditionCommonRepositoryImpl<T>
implements PortletContextAware,
DocumentEditionRepository<T> {
    public static final String TITLE_PROPERTY = "dc:title";
    private PortletContext portletContext;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DocumentEditionAttachmentsRepository attachmentsRepository;
    @Autowired
    private DocumentEditionMetadataRepository metadataRepository;

    protected DocumentEditionRepositoryImpl() {
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @Override
    public boolean matches(String documentType, boolean creation) {
        return false;
    }

    @Override
    public NuxeoDocumentContext getDocumentContext(PortalControllerContext portalControllerContext, String path) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return nuxeoController.getDocumentContext(path);
    }

    @Override
    public T get(PortalControllerContext portalControllerContext, Document document) throws PortletException, IOException {
        Class type = this.getParameterizedType();
        AbstractDocumentEditionForm form = (AbstractDocumentEditionForm)this.applicationContext.getBean(type);
        if (document != null) {
            String title = document.getTitle();
            form.setTitle(title);
            form.setOriginalTitle(title);
        }
        Attachments attachments = this.attachmentsRepository.get(portalControllerContext, document);
        form.setAttachments(attachments);
        DocumentEditionMetadata metadata = this.metadataRepository.get(portalControllerContext, document);
        form.setMetadata(metadata);
        this.customizeForm(portalControllerContext, document, form);
        return (T)form;
    }

    @Override
    public T getForm(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException, IOException {
        Document document;
        if (StringUtils.isEmpty((String)windowProperties.getDocumentPath())) {
            document = null;
        } else {
            NuxeoDocumentContext documentContext = this.getDocumentContext(portalControllerContext, windowProperties.getDocumentPath());
            document = documentContext.getDocument();
        }
        return (T)this.get(portalControllerContext, document);
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, T form) throws PortletException, IOException {
    }

    private T castForm(AbstractDocumentEditionForm form) {
        Class type = this.getParameterizedType();
        return (T)((AbstractDocumentEditionForm)type.cast(form));
    }

    @Override
    public void validate(AbstractDocumentEditionForm form, Errors errors) {
        this.customizeValidation(this.castForm(form), errors);
    }

    protected void customizeValidation(T form, Errors errors) {
        boolean available;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"NotEmpty");
        if (!(!((AbstractDocumentEditionForm)form).isCreation() && StringUtils.equalsIgnoreCase((String)((AbstractDocumentEditionForm)form).getOriginalTitle(), (String)((AbstractDocumentEditionForm)form).getTitle()) || (available = this.checkTitleAvailability(form)))) {
            errors.rejectValue("title", "Unavailable");
        }
    }

    private boolean checkTitleAvailability(T form) {
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        DocumentEditionWindowProperties windowProperties = ((AbstractDocumentEditionForm)form).getWindowProperties();
        String parentPath = ((AbstractDocumentEditionForm)form).isCreation() ? windowProperties.getParentDocumentPath() : StringUtils.substringBeforeLast((String)windowProperties.getDocumentPath(), (String)"/");
        NuxeoDocumentContext parentDocumentContext = nuxeoController.getDocumentContext(parentPath);
        Document parentDocument = parentDocumentContext.getDocument();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CheckTitleAvailabilityCommand.class, new Object[]{parentDocument.getId(), ((AbstractDocumentEditionForm)form).getTitle()});
        Boolean available = (Boolean)nuxeoController.executeNuxeoCommand(command);
        return BooleanUtils.isTrue((Boolean)available);
    }

    @Override
    public void upload(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        this.customizeUpload(portalControllerContext, this.castForm(form));
    }

    protected void customizeUpload(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    @Override
    public void restore(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        this.customizeRestore(portalControllerContext, this.castForm(form));
    }

    protected void customizeRestore(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    @Override
    public void save(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, List<EditorTemporaryAttachedPicture> pictures) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PropertyMap properties = new PropertyMap();
        properties.set(TITLE_PROPERTY, form.getTitle());
        LinkedHashMap<String, List<Blob>> binaries = new LinkedHashMap<String, List<Blob>>();
        this.addTemporaryAttachedPictures(portalControllerContext, pictures, binaries);
        this.attachmentsRepository.customizeProperties(portalControllerContext, form.getAttachments(), form.isCreation(), properties, (Map<String, List<Blob>>)binaries);
        this.metadataRepository.customizeProperties(portalControllerContext, form.getMetadata(), form.isCreation(), properties, (Map<String, List<Blob>>)binaries);
        this.customizeProperties(portalControllerContext, this.castForm(form), form.isCreation(), properties, binaries);
        if (form.isCreation()) {
            DocumentEditionWindowProperties windowProperties = form.getWindowProperties();
            String parentPath = windowProperties.getParentDocumentPath();
            String documentType = windowProperties.getDocumentType();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
            DocumentType parentDocumentType = documentContext.getDocumentType();
            if (parentDocumentType == null || !parentDocumentType.getSubtypes().contains(documentType)) {
                throw new PortletException("Invalid created document type.");
            }
            Document document = this.create(nuxeoController, parentPath, documentType, properties, binaries);
            if (document != null) {
                form.setPath(document.getPath());
            }
        } else {
            this.update(nuxeoController, form.getPath(), properties, binaries);
        }
    }

    private void addTemporaryAttachedPictures(PortalControllerContext portalControllerContext, List<EditorTemporaryAttachedPicture> pictures, Map<String, List<Blob>> binaries) {
        if (CollectionUtils.isNotEmpty(pictures)) {
            LinkedList<Object> blobs = new LinkedList<Object>();
            for (EditorTemporaryAttachedPicture picture : pictures) {
                NuxeoDocumentContext documentContext;
                Document document;
                PropertyMap fileContent;
                String data;
                if (picture.getFile() != null) {
                    FileBlob blob = new FileBlob(picture.getFile(), picture.getFileName(), picture.getContentType());
                    blobs.add(blob);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)picture.getSourcePath()) || !StringUtils.isNotEmpty((String)(data = (fileContent = (document = (documentContext = this.getDocumentContext(portalControllerContext, picture.getSourcePath())).getDocument()).getProperties().getMap("file:content")) == null ? null : fileContent.getString("data")))) continue;
                BlobRef blob = new BlobRef(data);
                blobs.add(blob);
            }
            binaries.put("ttc:images", blobs);
        }
    }

    @Override
    public void customizeProperties(PortalControllerContext portalControllerContext, T form, boolean creation, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
    }

    public Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
        CreateDocumentCommand command = (CreateDocumentCommand)this.applicationContext.getBean(CreateDocumentCommand.class);
        command.setParentPath(parentPath);
        command.setType(type);
        command.setProperties(properties);
        command.setBinaries(binaries);
        return (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }

    public void update(NuxeoController nuxeoController, String path, PropertyMap properties, Map<String, List<Blob>> binaries) throws PortletException, IOException {
        UpdateDocumentCommand command = (UpdateDocumentCommand)this.applicationContext.getBean(UpdateDocumentCommand.class);
        command.setPath(path);
        command.setProperties(properties);
        command.setBinaries(binaries);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
    }
}

