/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.configuration;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import org.osivia.portal.api.editor.EditorService;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.portlet.PortletAppUtils;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.multipart.CommonsPortletMultipartResolver;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

@Configuration
@ComponentScan(basePackages={"org.osivia.services.edition.portlet"})
public class DocumentEditionConfiguration
extends CMSPortlet
implements PortletConfigAware {
    @Autowired
    private ApplicationContext applicationContext;

    public void setPortletConfig(PortletConfig portletConfig) {
        try {
            super.init(portletConfig);
        }
        catch (PortletException e) {
            throw new RuntimeException(e);
        }
        PortletAppUtils.registerApplication((PortletConfig)portletConfig, (Object)this.applicationContext);
    }

    @Bean
    public InternalResourceViewResolver getViewResolver() {
        InternalResourceViewResolver viewResolver = new InternalResourceViewResolver();
        viewResolver.setCache(true);
        viewResolver.setViewClass(JstlView.class);
        viewResolver.setPrefix("/WEB-INF/jsp/");
        viewResolver.setSuffix(".jsp");
        return viewResolver;
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename("document-edition");
        return messageSource;
    }

    @Bean(name={"portletMultipartResolver"})
    public PortletMultipartResolver getMultipartResolver() {
        CommonsPortletMultipartResolver multipartResolver = new CommonsPortletMultipartResolver();
        multipartResolver.setDefaultEncoding("UTF-8");
        multipartResolver.setMaxUploadSize(DocumentEditionService.MAX_UPLOAD_SIZE);
        return multipartResolver;
    }

    @Bean
    public IPortalUrlFactory getPortalUrlFactory() {
        return (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    }

    @Bean
    public IBundleFactory getBundleFactory() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        return internationalizationService.getBundleFactory(this.getClass().getClassLoader(), this.applicationContext);
    }

    @Bean
    public INotificationsService getNotificationsService() {
        return (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
    }

    @Bean
    public EditorService getEditorService() {
        return (EditorService)Locator.findMBean(EditorService.class, (String)"osivia:service=EditorService");
    }
}

