/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.BlobRef;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public abstract class AbstractDocumentCommand
implements INuxeoCommand {
    private PropertyMap properties;
    private Map<String, List<Blob>> binaries;

    public String getId() {
        return null;
    }

    protected void updateBinaries(Session session, DocumentService documentService, DocRef document) throws Exception {
        if (MapUtils.isNotEmpty((Map)this.binaries)) {
            for (Map.Entry entry : this.binaries.entrySet()) {
                String xpath = (String)entry.getKey();
                List blobs = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)blobs)) {
                    documentService.removeBlob(document, xpath);
                    continue;
                }
                if (blobs.size() == 1) {
                    Blob resolvedBlob = this.resolveBlobRef(session, (Blob)blobs.get(0));
                    documentService.setBlob(document, resolvedBlob, xpath);
                    continue;
                }
                List resolvedBlobs = blobs.stream().map(item -> this.resolveBlobRef(session, item)).collect(Collectors.toList());
                documentService.setBlobs(document, new Blobs(resolvedBlobs), xpath);
            }
        }
    }

    private Blob resolveBlobRef(Session session, Blob blob) {
        Blob result;
        if (blob instanceof BlobRef) {
            BlobRef blobRef = (BlobRef)blob;
            try {
                result = session.getFile(blobRef.getRef());
            }
            catch (Exception e) {
                result = blob;
            }
        } else {
            result = blob;
        }
        return result;
    }

    public PropertyMap getProperties() {
        return this.properties;
    }

    public void setProperties(PropertyMap properties) {
        this.properties = properties;
    }

    public Map<String, List<Blob>> getBinaries() {
        return this.binaries;
    }

    public void setBinaries(Map<String, List<Blob>> binaries) {
        this.binaries = binaries;
    }
}

