/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.editor.EditorService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.model.FilesCreationForm;
import org.osivia.services.edition.portlet.model.Picture;
import org.osivia.services.edition.portlet.model.UploadTemporaryFile;
import org.osivia.services.edition.portlet.repository.DocumentEditionAttachmentsRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionDefaultRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionMetadataRepository;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepository;
import org.osivia.services.edition.portlet.repository.ZipExtractionRepositoryImpl;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class DocumentEditionServiceImpl
implements DocumentEditionService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DocumentEditionDefaultRepository defaultRepository;
    @Autowired
    private DocumentEditionAttachmentsRepository attachmentsRepository;
    @Autowired
    private DocumentEditionMetadataRepository metadataRepository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private EditorService editorService;

    public DocumentEditionWindowProperties getWindowProperties(PortalControllerContext portalControllerContext) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        DocumentEditionWindowProperties properties = (DocumentEditionWindowProperties)this.applicationContext.getBean(DocumentEditionWindowProperties.class);
        String documentPath = window.getProperty("osivia.document.edition.path");
        properties.setDocumentPath(documentPath);
        String parentDocumentPath = window.getProperty("osivia.document.edition.parent-path");
        properties.setParentDocumentPath(parentDocumentPath);
        String documentType = window.getProperty("osivia.document.edition.document-type");
        properties.setDocumentType(documentType);
        String extractArchive = window.getProperty("osivia.document.edition.extract-archive");
        properties.setExtractArchive(BooleanUtils.toBoolean((String)extractArchive));
        return properties;
    }

    public AbstractDocumentEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        DocumentEditionWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
        if (StringUtils.isEmpty((String)windowProperties.getDocumentPath()) && (StringUtils.isEmpty((String)windowProperties.getParentDocumentPath()) || StringUtils.isEmpty((String)windowProperties.getDocumentType()))) {
            throw new PortletException("Invalid window properties.");
        }
        String name = this.getRepositoryName(portalControllerContext, windowProperties);
        if (StringUtils.isEmpty((String)name)) {
            throw new PortletException("Unable to find portlet repository name.");
        }
        DocumentEditionRepository repository = this.getRepository(name);
        AbstractDocumentEditionForm form = repository.getForm(portalControllerContext, windowProperties);
        form.setWindowProperties(windowProperties);
        form.setName(name);
        String path = windowProperties.getDocumentPath();
        form.setPath(path);
        boolean creation = StringUtils.isEmpty((String)path);
        form.setCreation(creation);
        form.setRemoteUser(portalControllerContext.getRequest().getRemoteUser());
        return form;
    }

    public DocumentEditionRepository<?> getRepository(String name) {
        return (DocumentEditionRepository)this.applicationContext.getBean(name, DocumentEditionRepository.class);
    }

    public String getViewPath(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        AbstractDocumentEditionForm form = this.getForm(portalControllerContext);
        String title = form.getWindowProperties().isExtractArchive() ? bundle.getString("DOCUMENT_EDITION_TITLE_IMPORT") : (form.isCreation() ? bundle.getString("DOCUMENT_EDITION_TITLE_CREATE") : bundle.getString("DOCUMENT_EDITION_TITLE_EDIT"));
        response.setTitle(title);
        DocumentEditionRepository repository = this.getRepository(form.getName());
        return repository.getViewPath(portalControllerContext);
    }

    public void upload(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.upload(portalControllerContext, form);
    }

    public void restore(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.restore(portalControllerContext, form);
    }

    public void uploadAttachments(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        this.attachmentsRepository.uploadAttachments(portalControllerContext, form.getAttachments());
    }

    public void deleteAttachment(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String value) throws PortletException, IOException {
        this.attachmentsRepository.deleteAttachment(portalControllerContext, form.getAttachments(), value);
    }

    public void restoreAttachment(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String value) throws PortletException, IOException {
        this.attachmentsRepository.restoreAttachment(portalControllerContext, form.getAttachments(), value);
    }

    public void uploadPicture(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String pictureType) throws PortletException, IOException {
        Picture picture = this.getPicture(portalControllerContext, form, pictureType);
        if (picture != null) {
            this.defaultRepository.deleteTemporaryFile(picture.getTemporaryFile());
            UploadTemporaryFile temporaryFile = this.defaultRepository.createTemporaryFile(picture.getUpload());
            picture.setTemporaryFile(temporaryFile);
            picture.setDeleted(false);
        }
    }

    public void deletePicture(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String pictureType) throws PortletException, IOException {
        Picture picture = this.getPicture(portalControllerContext, form, pictureType);
        if (picture != null) {
            this.defaultRepository.deleteTemporaryFile(picture.getTemporaryFile());
            picture.setTemporaryFile(null);
            picture.setDeleted(true);
        }
    }

    public void restorePicture(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String pictureType) throws PortletException, IOException {
        Picture picture = this.getPicture(portalControllerContext, form, pictureType);
        if (picture != null) {
            this.defaultRepository.deleteTemporaryFile(picture.getTemporaryFile());
            picture.setTemporaryFile(null);
            picture.setDeleted(false);
        }
    }

    public void validate(AbstractDocumentEditionForm form, Errors errors) {
        DocumentEditionRepository repository = this.getRepository(form.getName());
        repository.validate(form, errors);
        this.attachmentsRepository.validate(form.getAttachments(), errors);
        this.metadataRepository.validate(form.getMetadata(), errors);
    }

    public void save(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) throws PortletException, IOException {
        List pictures;
        DocumentEditionWindowProperties windowProperties = form.getWindowProperties();
        DocumentEditionRepository repository = this.getRepository(form.getName());
        if (form.isCreation()) {
            try {
                pictures = this.editorService.getTemporaryAttachedPictures(portalControllerContext, windowProperties.getParentDocumentPath());
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            pictures = null;
        }
        repository.save(portalControllerContext, form, pictures);
        try {
            this.editorService.clearTemporaryAttachedPictures(portalControllerContext, windowProperties.getParentDocumentPath());
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        this.addNotification(portalControllerContext, form);
        this.redirect(portalControllerContext);
    }

    protected void addNotification(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form) {
        FilesCreationForm filesCreationForm;
        int size;
        PortletRequest request = portalControllerContext.getRequest();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String message = form instanceof FilesCreationForm ? ((size = CollectionUtils.size((Object)(filesCreationForm = (FilesCreationForm)form).getTemporaryFiles())) == 1 ? bundle.getString("DOCUMENT_EDITION_MESSAGE_ADD_ONE_FILE_SUCCESS") : bundle.getString("DOCUMENT_EDITION_MESSAGE_ADD_N_FILES_SUCCESS", new Object[]{size})) : (form.isCreation() ? bundle.getString("DOCUMENT_EDITION_MESSAGE_CREATION_SUCCESS") : bundle.getString("DOCUMENT_EDITION_MESSAGE_EDITION_SUCCESS"));
        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
    }

    public void cancel(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        DocumentEditionWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
        if (StringUtils.isEmpty((String)windowProperties.getDocumentPath())) {
            try {
                this.editorService.clearTemporaryAttachedPictures(portalControllerContext, windowProperties.getParentDocumentPath());
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        }
        this.redirect(portalControllerContext);
    }

    protected void redirect(PortalControllerContext portalControllerContext) throws IOException {
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof ActionResponse) {
            ActionResponse actionResponse = (ActionResponse)portletResponse;
            DocumentEditionWindowProperties windowProperties = this.getWindowProperties(portalControllerContext);
            String redirectionPath = StringUtils.defaultIfEmpty((String)windowProperties.getDocumentPath(), (String)windowProperties.getParentDocumentPath());
            String redirectionUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, redirectionPath, null, null, "refreshPageAndNavigation", null, null, null, null);
            actionResponse.sendRedirect(redirectionUrl);
        }
    }

    private String getRepositoryName(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties) throws PortletException {
        String repositoryName;
        if (windowProperties.isExtractArchive()) {
            String[] names = this.applicationContext.getBeanNamesForType(ZipExtractionRepositoryImpl.class);
            repositoryName = ArrayUtils.getLength((Object)names) == 1 ? names[0] : null;
        } else {
            List primaryRepositoryNames;
            boolean creation;
            String documentType;
            if (StringUtils.isEmpty((String)windowProperties.getDocumentPath())) {
                documentType = windowProperties.getDocumentType();
                creation = true;
            } else {
                NuxeoDocumentContext documentContext = this.defaultRepository.getDocumentContext(portalControllerContext, windowProperties.getDocumentPath());
                documentType = documentContext == null || documentContext.getDocumentType() == null ? null : documentContext.getDocumentType().getName();
                creation = false;
            }
            Map<String, DocumentEditionRepository> repositories = this.applicationContext.getBeansOfType(DocumentEditionRepository.class).entrySet().stream().filter(item -> ((DocumentEditionRepository)item.getValue()).matches(documentType, creation)).collect(Collectors.toMap(Map.Entry::getKey, item -> (DocumentEditionRepository)item.getValue()));
            repositoryName = MapUtils.isEmpty(repositories) ? null : (repositories.size() == 1 ? repositories.keySet().iterator().next() : ((primaryRepositoryNames = repositories.entrySet().stream().filter(item -> ((DocumentEditionRepository)item.getValue()).getClass().isAnnotationPresent(Primary.class)).map(Map.Entry::getKey).collect(Collectors.toList())).size() == 1 ? (String)primaryRepositoryNames.get(0) : null));
        }
        return repositoryName;
    }

    public void picturePreview(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String pictureType) throws PortletException, IOException {
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        Picture picture = this.getPicture(portalControllerContext, form, pictureType);
        if (picture == null) {
            throw new NuxeoException(3);
        }
        File temporaryFile = picture.getTemporaryFile().getFile();
        int size = Long.valueOf(temporaryFile.length()).intValue();
        response.setContentLength(size);
        String contentType = response.getContentType();
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        response.getCacheControl().setExpirationTime(0);
        InputStream inputSteam = Files.newInputStream(temporaryFile.toPath(), new OpenOption[0]);
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputSteam, (OutputStream)outputStream);
        outputStream.close();
    }

    protected Picture getPicture(PortalControllerContext portalControllerContext, AbstractDocumentEditionForm form, String pictureType) {
        Picture picture = "vignette".equals(pictureType) ? form.getMetadata().getVignette() : null;
        return picture;
    }

    public void serveEditor(PortalControllerContext portalControllerContext, String editorId) throws PortletException, IOException {
        this.editorService.serveResource(portalControllerContext, editorId);
    }
}

