/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.edition.portlet.model.AbstractDocumentEditionForm;
import org.osivia.services.edition.portlet.model.DocumentEditionWindowProperties;
import org.osivia.services.edition.portlet.repository.DocumentEditionRepository;
import org.osivia.services.edition.portlet.repository.command.CheckTitleAvailabilityCommand;
import org.osivia.services.edition.portlet.repository.command.CreateDocumentCommand;
import org.osivia.services.edition.portlet.repository.command.UpdateDocumentCommand;
import org.osivia.services.edition.portlet.service.DocumentEditionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

public abstract class AbstractDocumentEditionRepositoryImpl<T extends AbstractDocumentEditionForm>
implements DocumentEditionRepository<T> {
    protected static final String TITLE_PROPERTY = "dc:title";
    protected static final String DESCRIPTION_PROPERTY = "dc:description";
    protected static final String HIDE_FIRST_LEVEL_SYSTEM_PROPERTY = "osivia.services.userWorkSpace.hideFirstLevel";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private DocumentEditionService service;
    @Autowired
    private ICMSServiceLocator cmsServiceLocator;

    protected AbstractDocumentEditionRepositoryImpl() {
    }

    public NuxeoDocumentContext getDocumentContext(PortalControllerContext portalControllerContext, String path) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        return nuxeoController.getDocumentContext(path);
    }

    protected T getForm(PortalControllerContext portalControllerContext, DocumentEditionWindowProperties windowProperties, Class<? extends T> type) throws PortletException, IOException {
        AbstractDocumentEditionForm form = (AbstractDocumentEditionForm)this.applicationContext.getBean(type);
        if (StringUtils.isNotEmpty((String)windowProperties.getDocumentPath())) {
            NuxeoDocumentContext documentContext = this.getDocumentContext(portalControllerContext, windowProperties.getDocumentPath());
            Document document = documentContext.getDocument();
            String title = document.getTitle();
            form.setTitle(title);
            form.setOriginalTitle(title);
            String description = document.getString(DESCRIPTION_PROPERTY);
            form.setDescription(description);
            this.customizeForm(portalControllerContext, document, form);
        } else if (StringUtils.isNotEmpty((String)windowProperties.getBasePath()) && StringUtils.isNotEmpty((String)windowProperties.getParentDocumentPath())) {
            List breadcrumb = this.getBreadcrumb(portalControllerContext, windowProperties.getBasePath(), windowProperties.getParentDocumentPath());
            form.setBreadcrumb(breadcrumb);
        }
        return (T)form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getBreadcrumb(PortalControllerContext portalControllerContext, String basePath, String parentPath) {
        String userRootPath;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
        ArrayList<String> breadcrumb = new ArrayList<String>();
        boolean hideFirstLevel = false;
        if (BooleanUtils.isTrue((Boolean)BooleanUtils.toBooleanObject((String)System.getProperty(HIDE_FIRST_LEVEL_SYSTEM_PROPERTY))) && StringUtils.startsWith((String)parentPath, (String)(userRootPath = nuxeoController.getUserWorkspacePath()))) {
            hideFirstLevel = true;
        }
        while (!(!StringUtils.startsWith((String)parentPath, (String)basePath) || hideFirstLevel && StringUtils.equals((String)parentPath, (String)basePath))) {
            try {
                CMSItem navigationItem = cmsService.getPortalNavigationItem(cmsContext, basePath, parentPath);
                if (navigationItem == null) continue;
                Document document = (Document)navigationItem.getNativeItem();
                breadcrumb.add(0, document.getTitle());
            }
            catch (CMSException objectPath) {}
            continue;
            finally {
                CMSObjectPath objectPath = CMSObjectPath.parse((String)parentPath);
                CMSObjectPath parentObjectPath = objectPath.getParent();
                parentPath = parentObjectPath.toString();
            }
        }
        return breadcrumb;
    }

    protected void customizeForm(PortalControllerContext portalControllerContext, Document document, T form) throws PortletException, IOException {
    }

    public void validate(T form, Errors errors) {
        boolean available;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"NotEmpty");
        if (!(!form.isCreation() && StringUtils.equalsIgnoreCase((String)form.getOriginalTitle(), (String)form.getTitle()) || (available = this.checkTitleAvailability(form)))) {
            errors.rejectValue("upload", "Unavailable");
        }
    }

    private boolean checkTitleAvailability(T form) {
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        DocumentEditionWindowProperties windowProperties = form.getWindowProperties();
        String parentPath = form.isCreation() ? windowProperties.getParentDocumentPath() : StringUtils.substringBeforeLast((String)windowProperties.getDocumentPath(), (String)"/");
        NuxeoDocumentContext parentDocumentContext = nuxeoController.getDocumentContext(parentPath);
        Document parentDocument = parentDocumentContext.getDocument();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CheckTitleAvailabilityCommand.class, new Object[]{parentDocument.getId(), form.getTitle()});
        Boolean available = (Boolean)nuxeoController.executeNuxeoCommand(command);
        return BooleanUtils.isTrue((Boolean)available);
    }

    public void upload(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    public void restore(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
    }

    public void save(PortalControllerContext portalControllerContext, T form) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PropertyMap properties = new PropertyMap();
        properties.set(TITLE_PROPERTY, form.getTitle());
        properties.set(DESCRIPTION_PROPERTY, StringUtils.trimToNull((String)form.getDescription()));
        HashMap binaries = new HashMap();
        this.customizeProperties(portalControllerContext, form, properties, binaries);
        if (form.isCreation()) {
            DocumentEditionWindowProperties windowProperties = this.service.getWindowProperties(portalControllerContext);
            String parentPath = windowProperties.getParentDocumentPath();
            String documentType = windowProperties.getDocumentType();
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
            DocumentType parentDocumentType = documentContext.getDocumentType();
            if (parentDocumentType == null || !parentDocumentType.getSubtypes().contains(documentType)) {
                throw new PortletException("Invalid created document type.");
            }
            Document document = this.create(nuxeoController, parentPath, documentType, properties, binaries);
            form.setPath(document.getPath());
        } else {
            this.update(nuxeoController, form.getPath(), properties, binaries);
        }
    }

    protected void customizeProperties(PortalControllerContext portalControllerContext, T form, PropertyMap properties, Map<String, Blob> binaries) throws PortletException, IOException {
    }

    protected Document create(NuxeoController nuxeoController, String parentPath, String type, PropertyMap properties, Map<String, Blob> binaries) throws PortletException, IOException {
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CreateDocumentCommand.class, new Object[]{parentPath, type, properties, binaries});
        return (Document)nuxeoController.executeNuxeoCommand(command);
    }

    protected Document update(NuxeoController nuxeoController, String path, PropertyMap properties, Map<String, Blob> binaries) throws PortletException, IOException {
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(UpdateDocumentCommand.class, new Object[]{path, properties, binaries});
        return (Document)nuxeoController.executeNuxeoCommand(command);
    }
}

