/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.link.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchDocumentsCommand
implements INuxeoCommand {
    private static final String OPERATION_ID = "Document.QueryES";
    private static final String SCHEMAS = "dublincore, toutatice, file";
    private final String path;
    private final String filter;
    private final int page;

    public SearchDocumentsCommand(String path, String filter, int page) {
        this.path = path;
        this.filter = filter;
        this.page = page;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:path STARTSWITH '").append(this.path).append("' ");
        clause.append("AND dc:title IS NOT NULL ");
        clause.append("AND ttc:webid IS NOT NULL ");
        if (StringUtils.isNotBlank((String)this.filter)) {
            clause.append("AND ecm:fulltext = '").append(this.filter).append("' ");
        }
        clause.append("ORDER BY dc:title ASC");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)clause.toString());
        OperationRequest operationRequest = nuxeoSession.newRequest(OPERATION_ID);
        operationRequest.set("pageSize", (Object)10);
        operationRequest.set("currentPageIndex", (Object)this.page);
        operationRequest.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        operationRequest.set("X-NXDocumentProperties", (Object)SCHEMAS);
        return operationRequest.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getCanonicalName());
        builder.append("|");
        builder.append(this.path);
        builder.append("|");
        builder.append(this.filter);
        builder.append("|");
        builder.append(this.page);
        return builder.toString();
    }
}

