/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.image.portlet.model.EditorImageForm;
import org.osivia.services.editor.image.portlet.model.ImageSourceType;
import org.osivia.services.editor.image.portlet.model.validation.EditorImageFormValidator;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class EditorImageController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private EditorImageService service;
    @Autowired
    private EditorImageFormValidator formValidator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ActionMapping(name="submit", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="form") EditorImageForm form, BindingResult bindingResult) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!bindingResult.hasErrors()) {
            this.service.save(portalControllerContext, form);
        }
    }

    @ActionMapping(name="submit", params={"source-attached"})
    public void sourceAttachedRedirection(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorImageForm form) {
        response.setRenderParameter("view", ImageSourceType.ATTACHED.getId());
    }

    @ActionMapping(name="submit", params={"source-document"})
    public void sourceDocumentRedirection(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") EditorImageForm form) {
        response.setRenderParameter("view", ImageSourceType.DOCUMENT.getId());
    }

    @ModelAttribute(value="form")
    public EditorImageForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(PortletRequestDataBinder binder) {
        binder.setDisallowedFields(new String[]{"done", "availableSourceTypes", "loaded"});
        binder.setValidator((Validator)this.formValidator);
    }
}

