/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.editor.image.portlet.model.SearchScope;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchImageDocumentsCommand
implements INuxeoCommand {
    private static final String OPERATION_ID = "Document.QueryES";
    private final String basePath;
    private final String filter;
    private final SearchScope scope;

    public SearchImageDocumentsCommand(String basePath, String filter, SearchScope scope) {
        this.basePath = basePath;
        this.filter = filter;
        this.scope = scope;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("(ecm:primaryType = 'Picture' OR (ecm:primaryType = 'File' AND file:content/mime-type LIKE 'image%')) ");
        if (StringUtils.isNotBlank((String)this.filter)) {
            clause.append("AND (dc:title ILIKE '").append(this.filter).append("%' OR ecm:fulltext = '").append(this.filter).append("') ");
        }
        if (SearchScope.WORKSPACE.equals((Object)this.scope)) {
            clause.append("AND ecm:path STARTSWITH '").append(this.basePath).append("' ");
        }
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)clause.toString());
        OperationRequest operationRequest = nuxeoSession.newRequest(OPERATION_ID);
        operationRequest.set("X-NXDocumentProperties", (Object)"*");
        operationRequest.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        operationRequest.set("pageSize", (Object)50);
        operationRequest.set("currentPageIndex", (Object)0);
        return operationRequest.execute();
    }

    public String getId() {
        return null;
    }
}

