/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.common.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.common.model.SourceDocumentForm;
import org.osivia.services.editor.common.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

public abstract class SourceDocumentController {
    @Autowired
    private PortletContext portletContext;

    protected abstract CommonService getService();

    @RenderMapping
    public String view() {
        return "source-document";
    }

    @ActionMapping(value="select")
    public void select(ActionRequest request, ActionResponse response, @RequestParam(value="path") String path) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.getService().selectDocument(portalControllerContext, path);
    }

    @ResourceMapping(value="search")
    public void search(ResourceRequest request, ResourceResponse response, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="scope", required=false) String scope) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        response.setContentType("text/html");
        this.getService().serveSearchResults(portalControllerContext, filter, scope);
    }

    @ModelAttribute(value="documentForm")
    public SourceDocumentForm getDocumentForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.getService().getSourceDocumentForm(portalControllerContext);
    }
}

