/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.common.service;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.editor.common.model.SearchScope;
import org.osivia.services.editor.common.model.SourceDocumentForm;
import org.osivia.services.editor.common.repository.CommonRepository;
import org.osivia.services.editor.common.service.CommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;

public abstract class CommonServiceImpl
implements CommonService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private InternalResourceViewResolver viewResolver;
    @Autowired
    private DocumentDAO documentDao;

    protected abstract CommonRepository getRepository();

    public String resolveViewPath(PortalControllerContext portalControllerContext, String name) throws PortletException {
        String path;
        try {
            View view = this.viewResolver.resolveViewName(name, null);
            JstlView jstlView = (JstlView)view;
            path = jstlView.getUrl();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return path;
    }

    public SourceDocumentForm getSourceDocumentForm(PortalControllerContext portalControllerContext) {
        SourceDocumentForm form = (SourceDocumentForm)this.applicationContext.getBean(SourceDocumentForm.class);
        form.setScope(SearchScope.DEFAULT);
        form.setAvailableScopes(Arrays.asList(SearchScope.values()));
        return form;
    }

    public void serveSearchResults(PortalControllerContext portalControllerContext, String filter, String scope) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String basePath = window.getProperty("osivia.editor.basePath");
        String jspPath = this.resolveViewPath(portalControllerContext, "search-results");
        if (StringUtils.isBlank((String)filter)) {
            request.setAttribute("emptyFilter", (Object)true);
        } else {
            ArrayList<DocumentDTO> documents;
            PaginableDocuments nuxeoDocuments = this.getRepository().searchDocuments(portalControllerContext, basePath, filter, SearchScope.fromId((String)scope));
            if (nuxeoDocuments.isEmpty()) {
                documents = null;
            } else {
                documents = new ArrayList<DocumentDTO>(nuxeoDocuments.size());
                for (Document nuxeoDocument : nuxeoDocuments) {
                    DocumentDTO document = this.documentDao.toDTO(nuxeoDocument);
                    documents.add(document);
                }
            }
            request.setAttribute("results", documents);
            request.setAttribute("total", (Object)nuxeoDocuments.getTotalSize());
        }
        PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher(jspPath);
        dispatcher.include(request, response);
    }
}

