/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"view=attached"})
public class EditorImageSourceAttachedController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private EditorImageService service;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "source-attached";
    }

    @ActionMapping(name="submit", params={"upload"})
    public void add(ActionRequest request, ActionResponse response, @Validated @ModelAttribute(value="attachedForm") EditorImageSourceAttachedForm attachedForm) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.addAttachedImage(portalControllerContext, attachedForm);
    }

    @ActionMapping(value="select")
    public void select(ActionRequest request, ActionResponse response, @RequestParam(value="index") String index, @ModelAttribute(value="attachedForm") EditorImageSourceAttachedForm attachedForm) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.selectAttachedImage(portalControllerContext, attachedForm, NumberUtils.toInt((String)index));
    }

    @ActionMapping(value="delete")
    public void delete(ActionRequest request, ActionResponse response, @RequestParam(value="index") String index, @ModelAttribute(value="attachedForm") EditorImageSourceAttachedForm attachedForm) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteAttachedImage(portalControllerContext, attachedForm, NumberUtils.toInt((String)index));
        response.setRenderParameter("view", "attached");
    }

    @ResourceMapping(value="image-preview")
    public void imagePreview(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.serveImagePreview(portalControllerContext);
    }

    @ModelAttribute(value="attachedForm")
    public EditorImageSourceAttachedForm getAttachedForm(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getAttachedForm(portalControllerContext);
    }
}

