/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.editor.EditorService;
import org.osivia.portal.api.editor.EditorTemporaryAttachedPicture;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSBinaryContent;
import org.osivia.services.editor.common.repository.CommonRepository;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.image.portlet.model.AttachedImage;
import org.osivia.services.editor.image.portlet.model.EditorImageForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.osivia.services.editor.image.portlet.model.ImageSourceType;
import org.osivia.services.editor.image.portlet.model.TemporaryAttachedImage;
import org.osivia.services.editor.image.portlet.repository.EditorImageRepository;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorImageServiceImpl
extends CommonServiceImpl
implements EditorImageService {
    private static final String ATTACHED_IMAGE_URL_REGEX = "/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*";
    private final Pattern attachedImageUrlPattern = Pattern.compile("/nuxeo/nxfile/default/attachedImages/(?<property>[^/]+)/(?<index>[0-9]+)/file.*");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorImageRepository repository;
    @Autowired
    private EditorService editorService;

    protected CommonRepository getRepository() {
        return this.repository;
    }

    public EditorImageForm getForm(PortalControllerContext portalControllerContext) {
        EditorImageForm form = (EditorImageForm)this.applicationContext.getBean(EditorImageForm.class);
        if (!form.isLoaded()) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            boolean creation = BooleanUtils.toBoolean((String)window.getProperty("osivia.editor.creation"));
            form.setCreation(creation);
            String url = window.getProperty("osivia.editor.src");
            form.setUrl(url);
            String alt = window.getProperty("osivia.editor.alt");
            form.setAlt(alt);
            Integer height = NumberUtils.toInt((String)window.getProperty("osivia.editor.height"));
            if (height < 1) {
                height = null;
            }
            form.setHeight(height);
            Integer width = NumberUtils.toInt((String)window.getProperty("osivia.editor.width"));
            if (width < 1) {
                width = null;
            }
            form.setWidth(width);
            List<ImageSourceType> availableSourceTypes = Arrays.asList(ImageSourceType.ATTACHED, ImageSourceType.DOCUMENT);
            form.setAvailableSourceTypes(availableSourceTypes);
            form.setLoaded(true);
        }
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, EditorImageForm form) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        if (StringUtils.equals((String)form.getTemporaryUrl(), (String)form.getUrl())) {
            TemporaryAttachedImage temporaryAttachedImage = form.getTemporaryAttachedImage();
            if (form.isCreation()) {
                if (temporaryAttachedImage != null && temporaryAttachedImage.getFile() != null) {
                    EditorTemporaryAttachedPicture picture = new EditorTemporaryAttachedPicture();
                    picture.setFile(temporaryAttachedImage.getFile());
                    picture.setFileName(temporaryAttachedImage.getFileName());
                    picture.setContentType(temporaryAttachedImage.getContentType());
                    try {
                        this.editorService.addTemporaryAttachedPicture(portalControllerContext, path, picture);
                    }
                    catch (PortalException e) {
                        throw new PortletException((Throwable)e);
                    }
                } else if (StringUtils.isNotEmpty((String)form.getTemporaryImagePath())) {
                    Document source = this.repository.getDocument(portalControllerContext, form.getTemporaryImagePath());
                    PropertyMap fileContent = source.getProperties().getMap("file:content");
                    EditorTemporaryAttachedPicture picture = new EditorTemporaryAttachedPicture();
                    picture.setSourcePath(source.getPath());
                    picture.setFileName(source.getTitle());
                    if (fileContent != null) {
                        picture.setContentType(fileContent.getString("mime-type"));
                    }
                    try {
                        this.editorService.addTemporaryAttachedPicture(portalControllerContext, path, picture);
                    }
                    catch (PortalException e) {
                        throw new PortletException((Throwable)e);
                    }
                }
            } else if (temporaryAttachedImage != null && temporaryAttachedImage.getFile() != null) {
                this.repository.addAttachedImage(portalControllerContext, path, temporaryAttachedImage.getFile(), temporaryAttachedImage.getFileName(), temporaryAttachedImage.getContentType());
                this.deleteTemporaryFile(temporaryAttachedImage);
            } else if (StringUtils.isNotEmpty((String)form.getTemporaryImagePath())) {
                this.repository.copyAttachedImage(portalControllerContext, form.getTemporaryImagePath(), path);
            }
            form.setTemporaryAttachedImage(null);
            form.setTemporaryImagePath(null);
        }
        form.setDone(true);
    }

    public EditorImageSourceAttachedForm getAttachedForm(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        TreeSet<AttachedImage> attachedImages;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        EditorImageSourceAttachedForm attachedForm = (EditorImageSourceAttachedForm)this.applicationContext.getBean(EditorImageSourceAttachedForm.class);
        attachedForm.setMaxUploadSize(0x6400000L);
        if (BooleanUtils.toBoolean((String)window.getProperty("osivia.editor.creation"))) {
            List temporaryAttachedPictures;
            try {
                temporaryAttachedPictures = this.editorService.getTemporaryAttachedPictures(portalControllerContext, path);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
            if (CollectionUtils.isEmpty((Collection)temporaryAttachedPictures)) {
                attachedImages = null;
            } else {
                attachedImages = new TreeSet<AttachedImage>();
                for (int i = 0; i < temporaryAttachedPictures.size(); ++i) {
                    EditorTemporaryAttachedPicture picture = (EditorTemporaryAttachedPicture)temporaryAttachedPictures.get(i);
                    AttachedImage attachedImage = (AttachedImage)this.applicationContext.getBean(AttachedImage.class);
                    attachedImage.setIndex(i);
                    attachedImage.setFileName(picture.getFileName());
                    attachedImage.setTemporary(true);
                    attachedImages.add(attachedImage);
                }
            }
        } else {
            attachedImages = this.repository.getAttachedImages(portalControllerContext, path);
        }
        attachedForm.setAttachedImages((SortedSet)attachedImages);
        return attachedForm;
    }

    public void addAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm) throws PortletException, IOException {
        File temporaryFile = File.createTempFile("attached-image-", ".tmp");
        attachedForm.getUpload().transferTo(temporaryFile);
        String fileName = attachedForm.getUpload().getOriginalFilename();
        String contentType = attachedForm.getUpload().getContentType();
        EditorImageForm form = this.getForm(portalControllerContext);
        this.deleteTemporaryFile(form.getTemporaryAttachedImage());
        TemporaryAttachedImage temporaryAttachedImage = (TemporaryAttachedImage)this.applicationContext.getBean(TemporaryAttachedImage.class);
        temporaryAttachedImage.setFile(temporaryFile);
        temporaryAttachedImage.setFileName(fileName);
        temporaryAttachedImage.setContentType(contentType);
        form.setTemporaryAttachedImage(temporaryAttachedImage);
        int index = CollectionUtils.isEmpty((Collection)attachedForm.getAttachedImages()) ? 0 : attachedForm.getAttachedImages().size();
        String url = this.repository.getAttachedImageUrl(portalControllerContext, index, fileName);
        form.setUrl(url);
        form.setTemporaryUrl(url);
    }

    public void selectAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException, IOException {
        EditorImageForm form = this.getForm(portalControllerContext);
        AttachedImage attachedImage = this.getAttachedImage(attachedForm.getAttachedImages(), index);
        String url = attachedImage == null ? null : this.repository.getAttachedImageUrl(portalControllerContext, index, attachedImage.getFileName());
        form.setUrl(url);
        form.setTemporaryUrl(url);
        TemporaryAttachedImage temporaryAttachedImage = form.getTemporaryAttachedImage();
        if (!form.isCreation() && temporaryAttachedImage != null) {
            if (temporaryAttachedImage.getFile() != null && !temporaryAttachedImage.getFile().delete()) {
                temporaryAttachedImage.getFile().deleteOnExit();
            }
            form.setTemporaryAttachedImage(null);
        }
    }

    public void deleteAttachedImage(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm, int index) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String path = window.getProperty("osivia.editor.path");
        SortedSet attachedImages = attachedForm.getAttachedImages();
        AttachedImage attachedImage = this.getAttachedImage(attachedImages, index);
        if (attachedImage != null) {
            this.repository.deleteAttachedImage(portalControllerContext, path, index);
            attachedImages.remove(attachedImage);
        }
    }

    private AttachedImage getAttachedImage(SortedSet<AttachedImage> attachedImages, int index) {
        AttachedImage result = null;
        if (CollectionUtils.isNotEmpty(attachedImages)) {
            Iterator iterator = attachedImages.iterator();
            while (result == null && iterator.hasNext()) {
                AttachedImage item = (AttachedImage)iterator.next();
                if (index != item.getIndex()) continue;
                result = item;
            }
        }
        return result;
    }

    public void selectDocument(PortalControllerContext portalControllerContext, String path) throws PortletException, IOException {
        Document source = this.repository.getDocument(portalControllerContext, path);
        EditorImageSourceAttachedForm attachedForm = this.getAttachedForm(portalControllerContext);
        int index = CollectionUtils.isEmpty((Collection)attachedForm.getAttachedImages()) ? 0 : attachedForm.getAttachedImages().size();
        EditorImageForm form = this.getForm(portalControllerContext);
        this.deleteTemporaryFile(form.getTemporaryAttachedImage());
        form.setTemporaryAttachedImage(null);
        form.setTemporaryImagePath(path);
        String url = this.repository.getAttachedImageUrl(portalControllerContext, index, source.getTitle());
        form.setUrl(url);
        form.setTemporaryUrl(url);
    }

    private void deleteTemporaryFile(TemporaryAttachedImage temporaryAttachedImage) {
        if (temporaryAttachedImage != null && temporaryAttachedImage.getFile() != null && !temporaryAttachedImage.getFile().delete()) {
            temporaryAttachedImage.getFile().deleteOnExit();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveImagePreview(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        InputStream inputStream;
        ResourceRequest request = (ResourceRequest)portalControllerContext.getRequest();
        ResourceResponse response = (ResourceResponse)portalControllerContext.getResponse();
        String source = request.getParameter("src");
        if (BooleanUtils.toBoolean((String)request.getParameter("creation"))) {
            EditorTemporaryAttachedPicture picture;
            List pictures;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = StringUtils.defaultIfEmpty((String)window.getProperty("osivia.editor.path"), (String)this.repository.getCurrentPath(portalControllerContext));
            if (StringUtils.isEmpty((String)path)) {
                pictures = null;
            } else {
                try {
                    pictures = this.editorService.getTemporaryAttachedPictures(portalControllerContext, path);
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
            }
            int index = NumberUtils.toInt((String)request.getParameter("index"), (int)-1);
            if (index < 0) {
                String[] split = StringUtils.splitByWholeSeparator((String)source, (String)"/ttc:images/");
                index = ArrayUtils.getLength((Object)split) == 2 ? NumberUtils.toInt((String)StringUtils.substringBefore((String)split[1], (String)"/"), (int)-1) : -1;
            }
            if ((picture = CollectionUtils.isEmpty((Collection)pictures) || index < 0 || index >= pictures.size() ? null : (EditorTemporaryAttachedPicture)pictures.get(index)) == null) {
                throw new FileNotFoundException("Temporary attached picture not found");
            }
            if (picture.getFile() != null) {
                response.setContentType(picture.getContentType());
                inputStream = Files.newInputStream(picture.getFile().toPath(), new OpenOption[0]);
            } else {
                if (!StringUtils.isNotEmpty((String)picture.getSourcePath())) throw new FileNotFoundException("Unknown source: " + source);
                CMSBinaryContent binaryContent = this.repository.getSourcePreviewBinaryContent(portalControllerContext, picture.getSourcePath());
                response.setContentType(binaryContent.getMimeType());
                response.setContentLength(binaryContent.getFileSize().intValue());
                inputStream = Files.newInputStream(binaryContent.getFile().toPath(), new OpenOption[0]);
            }
        } else {
            CMSBinaryContent binaryContent;
            Matcher attachedImageUrlMatcher = this.attachedImageUrlPattern.matcher(source);
            if (StringUtils.startsWith((String)source, (String)"/nuxeo/web/")) {
                String webId = StringUtils.substringAfterLast((String)StringUtils.substringBefore((String)source, (String)"?"), (String)"/");
                Object[] parameters = StringUtils.split((String)StringUtils.substringAfter((String)source, (String)"?"), (String)"&");
                String content = "Original";
                if (ArrayUtils.isNotEmpty((Object[])parameters)) {
                    for (Object parameter : parameters) {
                        String[] split = StringUtils.split((String)parameter, (String)"=");
                        if (ArrayUtils.getLength((Object)split) != 2 || !StringUtils.equals((String)"content", (String)split[0])) continue;
                        content = split[1];
                    }
                }
                binaryContent = this.repository.getImageDocumentPreviewBinaryContent(portalControllerContext, webId, content);
            } else {
                if (!attachedImageUrlMatcher.matches()) throw new FileNotFoundException("Unknown source: " + source);
                int index = NumberUtils.toInt((String)attachedImageUrlMatcher.group("index"));
                binaryContent = this.repository.getAttachedImagePreviewBinaryContent(portalControllerContext, index);
            }
            response.setContentType(binaryContent.getMimeType());
            response.setContentLength(binaryContent.getFileSize().intValue());
            inputStream = Files.newInputStream(binaryContent.getFile().toPath(), new OpenOption[0]);
        }
        response.getCacheControl().setExpirationTime(0);
        OutputStream outputStream = response.getPortletOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

