<%@ taglib prefix="portlet" uri="http://java.sun.com/portlet_2_0" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="op" uri="http://www.osivia.org/jsp/taglib/osivia-portal" %>
<%@ taglib prefix="ttc" uri="http://www.toutatice.fr/jsp/taglib/toutatice" %>

<%@ page isELIgnored="false" %>


<portlet:defineObjects/>

<portlet:actionURL name="submit" var="submitUrl" copyCurrentRenderParameters="true"/>
<portlet:renderURL var="backUrl"/>

<c:set var="contextPath" value="${pageContext.request.contextPath}" />
<c:set var="namespace"><portlet:namespace/></c:set>


<link rel="stylesheet" type="text/css" href="${contextPath}/css/image/style.min.css">
<script type="text/javascript" src="${contextPath}/js/image/editor.min.js"></script>


<div class="editor-image">
    <%--@elvariable id="attachedForm" type="org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm"--%>
    <form:form action="${submitUrl}" method="post" enctype="multipart/form-data" modelAttribute="attachedForm">
        <%--Add--%>
        <spring:bind path="upload">
            <div class="form-group ${status.error ? 'has-error' : ''}">
                <form:label path="upload" cssClass="control-label"><op:translate key="EDITOR_IMAGE_ATTACHED_UPLOAD_LABEL"/></form:label>
                <c:set var="maxSize"><ttc:fileSize size="${attachedForm.maxUploadSize}" escapeHtml="false"/></c:set>
                <c:set var="fileSizeLimitExceededMessage"><op:translate key="EDITOR_IMAGE_MESSAGE_FILE_SIZE_LIMIT_EXCEEDED" args="${maxSize}"/></c:set>
                <form:input path="upload" type="file" data-max-size="${attachedForm.maxUploadSize}" data-size-limit-exceeded-message="${fileSizeLimitExceededMessage}" data-submit="${namespace}-upload"/>
                <form:errors path="upload" cssClass="help-block"/>
            </div>
        </spring:bind>

        <%--Select--%>
        <div class="form-group">
            <label class="control-label"><op:translate key="EDITOR_IMAGE_ATTACHED_SELECT_LABEL"/></label>
            <c:choose>
                <c:when test="${empty attachedForm.attachedImages}">
                    <p class="form-control-static text-muted"><op:translate key="EDITOR_IMAGE_ATTACHED_SELECT_EMPTY"/></p>
                </c:when>

                <c:otherwise>
                    <div class="row">
                        <c:forEach var="attachedImage" items="${attachedForm.attachedImages}" varStatus="status">
                            <portlet:actionURL var="selectUrl" name="select" copyCurrentRenderParameters="true">
                                <portlet:param name="index" value="${attachedImage.index}"/>
                            </portlet:actionURL>

                            <div class="col-xs-6 col-sm-4">
                                <a href="${selectUrl}" class="thumbnail" title="${attachedImage.fileName}">
                                    <c:choose>
                                        <c:when test="${attachedImage.temporary}">
                                            <portlet:resourceURL var="imageUrl" id="image-preview">
                                                <portlet:param name="creation" value="true"/>
                                                <portlet:param name="index" value="${attachedImage.index}"/>
                                            </portlet:resourceURL>

                                            <img src="${imageUrl}" alt="">
                                        </c:when>
                                        <c:otherwise>
                                            <img src="${attachedImage.url}" alt="">
                                        </c:otherwise>
                                    </c:choose>
                                    <span>${attachedImage.fileName}</span>
                                </a>
                            </div>
                        </c:forEach>
                    </div>
                </c:otherwise>
            </c:choose>
        </div>

        <%--Buttons--%>
        <div class="text-right">
            <a href="${backUrl}" class="btn btn-default">
                <span><op:translate key="BACK"/></span>
            </a>
        </div>

        <input id="${namespace}-upload" type="submit" name="upload" class="hidden">
    </form:form>
</div>
