/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.plugin.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.osivia.portal.api.editor.EditorModule;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.plugin.model.editor.EditorHelper;
import org.osivia.services.editor.plugin.service.EditorPluginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorPluginServiceImpl
extends CommonServiceImpl
implements EditorPluginService {
    @Autowired
    private ApplicationContext applicationContext;

    public void customizeEditorModules(List<EditorModule> modules) {
        Object[] helpers = EditorHelper.values();
        if (ArrayUtils.isNotEmpty((Object[])helpers)) {
            for (Object helper : helpers) {
                EditorModule module = new EditorModule();
                module.setId(helper.getId());
                module.setInstance(helper.getInstance());
                module.setKey(helper.getKey());
                module.setClassLoader(this.getClass().getClassLoader());
                module.setApplicationContext(this.applicationContext);
                if (ArrayUtils.isNotEmpty((Object[])helper.getParameters())) {
                    HashSet<String> parameters = new HashSet<String>(Arrays.asList(helper.getParameters()));
                    module.setParameters(parameters);
                }
                modules.add(module);
            }
        }
    }
}

