/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchImageDocumentsCommand
implements INuxeoCommand {
    private static final String OPERATION_ID = "Document.QueryES";
    private final String filter;

    public SearchImageDocumentsCommand(String filter) {
        this.filter = filter;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("(ecm:primaryType = 'Picture' OR (ecm:primaryType = 'File' AND file:content/mime-type LIKE 'image%')) ");
        if (StringUtils.isNotBlank((String)this.filter)) {
            clause.append("AND ecm:fulltext = '" + this.filter + "' ");
        }
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)clause.toString());
        OperationRequest operationRequest = nuxeoSession.newRequest(OPERATION_ID);
        operationRequest.set("X-NXDocumentProperties", (Object)"*");
        operationRequest.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        operationRequest.set("pageSize", (Object)50);
        operationRequest.set("currentPageIndex", (Object)0);
        return operationRequest.execute();
    }

    public String getId() {
        return null;
    }
}

