/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.editor.image.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.editor.common.service.CommonServiceImpl;
import org.osivia.services.editor.image.portlet.model.EditorImageForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceAttachedForm;
import org.osivia.services.editor.image.portlet.model.EditorImageSourceDocumentForm;
import org.osivia.services.editor.image.portlet.model.ImageSourceType;
import org.osivia.services.editor.image.portlet.repository.EditorImageRepository;
import org.osivia.services.editor.image.portlet.service.EditorImageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class EditorImageServiceImpl
extends CommonServiceImpl
implements EditorImageService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private EditorImageRepository repository;
    @Autowired
    private DocumentDAO documentDao;

    public EditorImageForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        EditorImageForm form = (EditorImageForm)this.applicationContext.getBean(EditorImageForm.class);
        if (!form.isLoaded()) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            String path = window.getProperty("osivia.editor.path");
            Document document = this.repository.getDocument(portalControllerContext, path);
            boolean attachments = document.getProperties().getList("files:files") != null;
            String url = window.getProperty("osivia.editor.src");
            form.setUrl(url);
            String alt = window.getProperty("osivia.editor.alt");
            form.setAlt(alt);
            ArrayList<ImageSourceType> availableSourceTypes = new ArrayList<ImageSourceType>();
            if (attachments) {
                availableSourceTypes.add(ImageSourceType.ATTACHED);
            }
            availableSourceTypes.add(ImageSourceType.DOCUMENT);
            form.setAvailableSourceTypes(availableSourceTypes);
            form.setLoaded(true);
        }
        return form;
    }

    public void save(PortalControllerContext portalControllerContext, EditorImageForm form) throws PortletException {
        form.setDone(true);
    }

    public EditorImageSourceAttachedForm getAttachedForm(PortalControllerContext portalControllerContext) throws PortletException {
        return (EditorImageSourceAttachedForm)this.applicationContext.getBean(EditorImageSourceAttachedForm.class);
    }

    public void selectAttached(PortalControllerContext portalControllerContext, EditorImageSourceAttachedForm attachedForm) throws PortletException {
        EditorImageForm form = this.getForm(portalControllerContext);
    }

    public EditorImageSourceDocumentForm getDocumentForm(PortalControllerContext portalControllerContext) throws PortletException {
        EditorImageSourceDocumentForm form = (EditorImageSourceDocumentForm)this.applicationContext.getBean(EditorImageSourceDocumentForm.class);
        List documents = this.search(portalControllerContext, null);
        form.setDocuments(documents);
        return form;
    }

    public void filterDocuments(PortalControllerContext portalControllerContext, EditorImageSourceDocumentForm documentForm) throws PortletException {
        List documents = this.search(portalControllerContext, documentForm.getFilter());
        documentForm.setDocuments(documents);
    }

    public void selectDocument(PortalControllerContext portalControllerContext, String path) throws PortletException {
        EditorImageForm form = this.getForm(portalControllerContext);
        String url = this.repository.getImageDocumentUrl(portalControllerContext, path);
        form.setUrl(url);
    }

    private List<DocumentDTO> search(PortalControllerContext portalControllerContext, String filter) throws PortletException {
        ArrayList<DocumentDTO> documents;
        List nuxeoDocuments = this.repository.search(portalControllerContext, filter);
        if (CollectionUtils.isEmpty((Collection)nuxeoDocuments)) {
            documents = null;
        } else {
            documents = new ArrayList<DocumentDTO>(nuxeoDocuments.size());
            for (Document nuxeoDocument : nuxeoDocuments) {
                DocumentDTO document = this.documentDao.toDTO(nuxeoDocument);
                documents.add(document);
            }
        }
        return documents;
    }
}

