/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.faq.portail;

import fr.toutatice.faq.portail.FaqFetchChildrenCommand;
import fr.toutatice.faq.portail.Question;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.path.PortletPathItem;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class FaqPortlet
extends CMSPortlet {
    private static final String VIEW_JSP = "/WEB-INF/jsp/view.jsp";
    private static final String ERROR_JSP = "/WEB-INF/jsp/error.jsp";
    private static final String ADMIN_JSP = "/WEB-INF/jsp/admin.jsp";
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.documentDAO = DocumentDAO.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        String action = request.getParameter("javax.portlet.action");
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                window.setProperty("osivia.cms.uri", StringUtils.trimToNull((String)request.getParameter("path")));
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        request.setAttribute("path", (Object)window.getProperty("osivia.cms.uri"));
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(ADMIN_JSP).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher;
        String errorMessageKey = null;
        try {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            String path = request.getParameter("curItemPath");
            if (path == null) {
                path = window.getProperty("osivia.cms.uri");
            }
            NuxeoDocumentContext documentContext = null;
            documentContext = path != null ? NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)path) : NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext());
            if ("1".equals(window.getProperty("osivia.cms.contextualization"))) {
                request.setAttribute("contextualization", (Object)"1");
            }
            if (documentContext != null) {
                Document faq;
                String faqPath;
                Document question;
                Document document = documentContext.getDoc();
                NuxeoDocumentContext faqContext = null;
                String type = document.getType();
                if ("Question".equals(type)) {
                    question = document;
                    faqPath = NuxeoController.getParentPath((String)document.getPath());
                    faqContext = NuxeoController.getDocumentContext((PortletRequest)request, (PortletResponse)response, (PortletContext)this.getPortletContext(), (String)faqPath);
                    faq = faqContext.getDoc();
                } else if ("FaqFolder".equals(type)) {
                    faqContext = documentContext;
                    faq = document;
                    question = null;
                } else {
                    errorMessageKey = "ERROR_NOT_FAQ_TYPE";
                    faq = null;
                    question = null;
                }
                if (faq != null) {
                    faqPath = faq.getPath();
                    String faqLiveId = ((BasicPublicationInfos)faqContext.getPublicationInfos(BasicPublicationInfos.class)).getLiveId();
                    NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                    NuxeoQueryFilterContext queryContext = nuxeoController.getQueryFilterContextForPath(faqPath);
                    FaqFetchChildrenCommand command = new FaqFetchChildrenCommand(queryContext, faqLiveId);
                    Documents questions = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    if (question != null) {
                        nuxeoController.setCurrentDoc(question);
                    } else {
                        nuxeoController.setCurrentDoc(faq);
                    }
                    ArrayList portletPath = new ArrayList();
                    if (question != null) {
                        this.addPathItem(portletPath, question);
                    }
                    this.addPathItem(portletPath, faq);
                    request.setAttribute("osivia.portletPath", portletPath);
                    if (question != null) {
                        response.setTitle(question.getTitle());
                    } else {
                        response.setTitle(faq.getTitle());
                    }
                    nuxeoController.insertContentMenuBarItems();
                    DocumentDTO faqDTO = this.documentDAO.toDTO(faq);
                    request.setAttribute("faq", (Object)faqDTO);
                    if (question != null) {
                        DocumentDTO dto = this.documentDAO.toDTO(question);
                        this.generateAttachments(nuxeoController, question, dto);
                        Question vo = new Question();
                        BeanUtils.copyProperties((Object)vo, (Object)dto);
                        vo.setMessage(nuxeoController.transformHTMLContent(question.getString("note:note")));
                        request.setAttribute("question", (Object)vo);
                    }
                    ArrayList<DocumentDTO> questionsDTO = new ArrayList<DocumentDTO>(questions.size());
                    for (Document doc : questions.list()) {
                        DocumentDTO dto = this.documentDAO.toDTO(doc);
                        questionsDTO.add(dto);
                    }
                    request.setAttribute("questions", questionsDTO);
                }
            } else {
                errorMessageKey = "ERROR_PATH_UNDEFINED";
            }
        }
        catch (NuxeoException e) {
            PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
        }
        catch (IllegalAccessException e) {
            throw new PortletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PortletException((Throwable)e);
        }
        response.setContentType("text/html");
        if (errorMessageKey == null) {
            dispatcher = this.getPortletContext().getRequestDispatcher(VIEW_JSP);
        } else {
            request.setAttribute("errorKey", errorMessageKey);
            dispatcher = this.getPortletContext().getRequestDispatcher(ERROR_JSP);
        }
        dispatcher.include(request, response);
    }

    private void addPathItem(List<PortletPathItem> portletPath, Document document) {
        HashMap<String, String> renderParams = new HashMap<String, String>();
        renderParams.put("curItemPath", document.getPath());
        PortletPathItem pathItem = new PortletPathItem(renderParams, document.getTitle());
        portletPath.add(0, pathItem);
    }

    private void generateAttachments(NuxeoController nuxeoController, Document document, DocumentDTO documentDTO) {
        List attachments = documentDTO.getAttachments();
        PropertyList files = document.getProperties().getList("files:files");
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PropertyMap map = files.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                String name = map.getString("filename");
                attachment.setName(name);
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }
}

