<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="osivia-portal" prefix="op"%>
<%@ taglib uri="internationalization" prefix="is"%>


<div class="post">
    <div class="post-content">
        <div class="post-header">
            <div class="post-header-content">
                <div class="author">${post.author}</div>
                <div class="creation-date">${post.creationDate}</div>
                <div class="title">${post.title}</div>
            </div>
        </div>

        <div class="avatar">
            <portlet:resourceURL id="avatar" var="avatarResourceURL">
                <portlet:param name="user" value="${post.author}" />
            </portlet:resourceURL>
        
            <img src="${avatarResourceURL}" alt="">
        </div>

        <div class="content"><c:out value="${post.content}" escapeXml="false" /></div>

        <c:if test="${not empty post.filename}">
            <portlet:resourceURL id="${post.id}/post:fileContent" var="attachmentResourceURL">
                <portlet:param name="type" value="file" />
                <portlet:param name="docPath" value="${post.path}" />
                <portlet:param name="fieldName" value="post:fileContent" />
                <portlet:param name="filename" value="${post.filename}" />
            </portlet:resourceURL>

            <div class="attachment">
                <is:getProperty key="ATTACHMENT" /> : <a href="${attachmentResourceURL}">${post.filename}</a>
            </div>
        </c:if>

        <div class="actions">
        	<c:if test="${thread.commentable}">
	            <div class="reply">
	                <a class="portlet-menuitem" onclick="toggleReplyInput(this, '${op:escapeJavaScript(post.title)}', false)"><is:getProperty key="REPLY" /></a>
	            </div>
           </c:if>
            
            <c:if test="${post.deletable}">
                <div class="delete">
                    <a class="portlet-menuitem no-ajax-link fancybox_inline" href="#${namespace}-delete-fancybox" onclick="selectCommentToDelete('${post.id}')"><is:getProperty key="DELETE" /></a>
                </div>
            </c:if>
        </div>

        <c:set var="root" value="false" scope="request" />
        <c:set var="parentId" value="${post.id}" scope="request" />        
        <jsp:include page="reply-form.jsp" />
    </div>

    <c:if test="${not empty post.children}">
        <div class="children">
            <c:forEach var="child" items="${post.children}">
                <c:set var="post" value="${child}" scope="request" />
                <jsp:include page="display-post.jsp" />
            </c:forEach>
        </div>
    </c:if>
</div>
