/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.portlets.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.services.forum.portlets.model.ThreadPostReplyForm;
import org.osivia.services.forum.portlets.model.ThreadVO;
import org.osivia.services.forum.portlets.service.ForumServiceImpl;
import org.osivia.services.forum.portlets.service.IForumService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller(value="forumController")
@RequestMapping(value={"VIEW"})
public class ForumPortletController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String VIEW_PATH = "view";
    @Autowired
    private IForumService forumService;
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    private IBundleFactory bundleFactory;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
        IInternationalizationService internationalizationService = (IInternationalizationService)this.portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException, CMSException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        Document document = this.forumService.getDocument(nuxeoController);
        response.setTitle(document.getTitle());
        this.fillMenubar(request, response, nuxeoController, document);
        return VIEW_PATH;
    }

    private void fillMenubar(RenderRequest request, RenderResponse response, NuxeoController nuxeoController, Document document) throws PortletException, CMSException {
        ForumServiceImpl forumServiceImpl = (ForumServiceImpl)this.forumService;
        boolean isCommentable = forumServiceImpl.isThreadCommentable(nuxeoController, document);
        if (isCommentable) {
            List menubar = (List)request.getAttribute("osivia.menuBar");
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            String title = bundle.getString("ADD_POST");
            StringBuilder url = new StringBuilder();
            url.append("#");
            url.append(response.getNamespace());
            url.append("-reply-form");
            StringBuilder onclick = new StringBuilder();
            onclick.append("toggleReplyInput(null, '");
            onclick.append(StringEscapeUtils.escapeJavaScript((String)document.getTitle()));
            onclick.append("', true)");
            MenubarItem item = new MenubarItem("ADD_POST", title, 0, url.toString(), onclick.toString(), null, null);
            item.setGlyphicon("halflings plus");
            item.setAjaxDisabled(true);
            menubar.add(item);
        }
        nuxeoController.setCurrentDoc(document);
        try {
            nuxeoController.insertContentMenuBarItems();
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    @ActionMapping(value="add")
    public void addCommentAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="posts") List<ThreadPostDTO> posts, @ModelAttribute(value="replyForm") ThreadPostReplyForm replyForm, @RequestParam(value="parentId", required=false) String parentId) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.forumService.addThreadPost(nuxeoController, posts, replyForm, parentId);
    }

    @ActionMapping(value="delete")
    public void deleteCommentAction(ActionRequest request, ActionResponse response, @ModelAttribute(value="posts") List<ThreadPostDTO> posts, @RequestParam(value="id", required=true) String id) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.portletContext);
        this.forumService.deleteThreadPost(nuxeoController, posts, id);
    }

    @ResourceMapping
    public void downloadAttachment(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        this.serveResource(request, response);
    }

    @ModelAttribute(value="thread")
    public ThreadVO getThread(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return this.forumService.getThread(nuxeoController);
    }

    @ModelAttribute(value="posts")
    public List<ThreadPostDTO> getPosts(PortletRequest request, PortletResponse response) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(request, response, this.portletContext);
        return this.forumService.getThreadPosts(nuxeoController);
    }

    @ModelAttribute(value="replyForm")
    public ThreadPostReplyForm getReplyForm(PortletRequest request, PortletResponse response) throws PortletException {
        return new ThreadPostReplyForm();
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

