<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="osivia-portal" prefix="op"%>
<%@ taglib uri="internationalization" prefix="is"%>




<div class="post clearfix">
    <img src="${post.person.avatar.url}" alt="avatar" class="avatar pull-left" />

    <div class="btn-group btn-group-sm pull-right">
        <c:if test="${thread.commentable}">
            <c:set var="title">
                <is:getProperty key="REPLY" />
            </c:set>
        
            <a onclick="toggleReplyInput(this, '${op:escapeJavaScript(post.title)}', false)" class="btn btn-default" title="${title}" data-toggle="tooltip" data-placement="bottom">
                <i class="glyphicons halflings comments"></i>
            </a>
        </c:if>

        <c:if test="${post.deletable}">
            <c:set var="title">
                <is:getProperty key="DELETE" />
            </c:set>
        
            <a href="#${namespace}-delete-fancybox" onclick="selectCommentToDelete('${post.id}')" class="btn btn-default fancybox_inline no-ajax-link" title="${title}" data-toggle="tooltip" data-placement="bottom">
                <i class="glyphicons halflings remove"></i>
            </a>
        </c:if>
    </div>

    <div>
        <p class="title">${post.person.displayName} - ${post.creationDate} - <strong>${post.title}</strong></p>
        <p class="content">${post.content}</p>
        
        <c:if test="${not empty post.filename}">
            <portlet:resourceURL id="${post.id}/post:fileContent" var="attachmentResourceURL">
                <portlet:param name="type" value="file" />
                <portlet:param name="docPath" value="${post.path}" />
                <portlet:param name="fieldName" value="post:fileContent" />
                <portlet:param name="filename" value="${post.filename}" />
            </portlet:resourceURL>

            <div class="attachment">
                <i class="glyphicons halflings uni-paperclip"></i>
                <a href="${attachmentResourceURL}">${post.filename}</a>
            </div>
        </c:if>
    </div>


    <c:set var="root" value="false" scope="request" />
    <c:set var="parentId" value="${post.id}" scope="request" />
    <jsp:include page="reply-form.jsp" />
</div>

<c:if test="${not empty post.children}">
    <ul class="list-unstyled children">
        <c:forEach var="child" items="${post.children}">
            <c:set var="post" value="${child}" scope="request" />
            
            <li>
                <jsp:include page="display-post.jsp" />
            </li>
        </c:forEach>
    </ul>
</c:if>


<!-- <div class="post"> -->
<!--     <div class="post-content"> -->
<!--         <div class="post-header"> -->
<!--             <div class="post-header-content"> -->
<%--                 <div class="author"><img src="${post.person.avatar.url}" class="avatar" /> ${post.person.displayName}</div> --%>
<%--                 <div class="creation-date">${post.creationDate}</div> --%>
<%--                 <div class="title">${post.title}</div> --%>
<!--             </div> -->
<!--         </div> -->


<%--         <div class="content"><c:out value="${post.content}" escapeXml="false" /></div> --%>

<%--         <c:if test="${not empty post.filename}"> --%>
<%--             <portlet:resourceURL id="${post.id}/post:fileContent" var="attachmentResourceURL"> --%>
<%--                 <portlet:param name="type" value="file" /> --%>
<%--                 <portlet:param name="docPath" value="${post.path}" /> --%>
<%--                 <portlet:param name="fieldName" value="post:fileContent" /> --%>
<%--                 <portlet:param name="filename" value="${post.filename}" /> --%>
<%--             </portlet:resourceURL> --%>

<!--             <div class="attachment"> -->
<%--                 <is:getProperty key="ATTACHMENT" /> : <a href="${attachmentResourceURL}">${post.filename}</a> --%>
<!--             </div> -->
<%--         </c:if> --%>

<!--         <div class="actions btn-group"> -->
<%--         	<c:if test="${thread.commentable}"> --%>
<%--         		<a class="btn btn-default" onclick="toggleReplyInput(this, '${op:escapeJavaScript(post.title)}', false)">  --%>
<!-- 					<i class="glyphicons comments"></i> -->
<%-- 					<span><is:getProperty key="REPLY" /></span> --%>
<!-- 				</a> -->

<%--            </c:if> --%>
            
<%--             <c:if test="${post.deletable}"> --%>
            
<%--         		<a class="portlet-menuitem no-ajax-link  btn btn-default fancybox_inline" href="#${namespace}-delete-fancybox" onclick="selectCommentToDelete('${post.id}')">  --%>
<!-- 					<i class="glyphicons remove_2"></i> -->
<%-- 					<is:getProperty key="DELETE" /> --%>
<!-- 				</a> -->

<%--             </c:if> --%>
<!--         </div> -->

<%--         <c:set var="root" value="false" scope="request" /> --%>
<%--         <c:set var="parentId" value="${post.id}" scope="request" />         --%>
<%--         <jsp:include page="reply-form.jsp" /> --%>
<!--     </div> -->

<%--     <c:if test="${not empty post.children}"> --%>
<!--         <div class="children"> -->
<%--             <c:forEach var="child" items="${post.children}"> --%>
<%--                 <c:set var="post" value="${child}" scope="request" /> --%>
<%--                 <jsp:include page="display-post.jsp" /> --%>
<%--             </c:forEach> --%>
<!--         </div> -->
<%--     </c:if> --%>
<!-- </div> -->
