<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="internationalization" prefix="is"%>


<portlet:actionURL name="add" var="addActionURL">
    <c:if test="${not empty parentId}">
        <portlet:param name="parentId" value="${parentId}" />
    </c:if>
</portlet:actionURL>


<div class="reply-input well">
    <form:form name="add" commandName="replyForm" method="post" action="${addActionURL}" enctype="multipart/form-data" role="form">
        <fieldset>
            <legend>
                <c:choose>
                    <c:when test="${root}">
                        <is:getProperty key="ADD_POST" />
                    </c:when>
                    
                    <c:otherwise>
                        <is:getProperty key="REPLY" />
                    </c:otherwise>
                </c:choose>
            </legend>

            <div class="form-group reply-title">
                <c:set var="label"><is:getProperty key="TITLE" /></c:set>
                
                <form:label path="title">${label}</form:label>
                <form:input path="title" class="form-control" placeholder="${label}" />
            </div>
            
            <div class="form-group reply-content">
                <c:set var="label"><is:getProperty key="CONTENT" /></c:set>
                
                <form:label path="content">${label}</form:label>
                <form:textarea path="content" rows="4" class="form-control" />
            </div>
            
            <div class="form-group">
                <c:set var="label"><is:getProperty key="ATTACHMENT" /></c:set>
                
                <form:label path="attachment">${label}</form:label>
                <form:input type="file" path="attachment" />
            </div>
            
            <button type="submit" class="btn btn-primary"><is:getProperty key="REPLY" /></button>
            <button type="button" class="btn btn-default" onclick="closeReplyInput()"><is:getProperty key="CANCEL" /></button>
        </fieldset>
    </form:form>
</div>