<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>
<%@ taglib uri="osivia-portal" prefix="op"%>
<%@ taglib uri="internationalization" prefix="is"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<portlet:defineObjects />

<portlet:actionURL name="delete" var="deleteActionURL" />


<c:set var="namespace" scope="request">
    <portlet:namespace />
</c:set>


<div class="forum">
    <ul class="list-group">
        <li class="list-group-item active">
            <div class="clearfix">
                <img src="${thread.person.avatar.url}" alt="avatar" class="avatar pull-left" />
                
                <div>
                    <p class="title">${thread.person.displayName} - ${thread.creationDate} - <strong>${thread.title}</strong></p>
                    <p class="description">${thread.description}</p>
                    <p class="message">${thread.message}</p>
                </div>
            </div>
        </li>
        
        <c:forEach var="child" items="${posts}">
            <c:set var="post" value="${child}" scope="request" />
            
            <li class="list-group-item">
                <jsp:include page="display-post.jsp" />
            </li>
        </c:forEach>
    </ul>
    
    
    <div class="btn-toolbar">
        <c:if test="${not empty posts and thread.commentable}">
            <div class="btn-group pull-right">
                <a onclick="toggleReplyInput(this, '${op:escapeJavaScript(thread.title)}', true)" class="btn btn-default">
                    <i class="glyphicons halflings plus"></i>
                    <span><is:getProperty key="ADD_POST" /></span>
                </a>
            </div>
        </c:if>
    </div>

    <div id="${namespace}-reply-form">
        <c:set var="root" value="true" scope="request" />
        <c:remove var="parentId" scope="request" />
        <jsp:include page="reply-form.jsp" />
    </div>


    <!-- Fancybox -->
    <div class="hidden">
        <div id="${namespace}-delete-fancybox" class="container-fluid">
            <form id="${namespace}-delete-form" action="${deleteActionURL}" method="post" class="form-horizontal" role="form">
                <p class="help-block"><is:getProperty key="COMMENT_SUPPRESSION_CONFIRM_MESSAGE" /></p>
                <div class="text-center">
                    <button type="submit" class="btn btn-default btn-warning">
                        <i class="glyphicons halflings warning-sign"></i>
                        <span><is:getProperty key="YES" /></span>
                    </button>
                    <button type="button" class="btn btn-default" onclick="closeFancybox()"><is:getProperty key="NO" /></button>
                </div>
            </form>
        </div>
    </div>
</div>


<script type="text/javascript">
function toggleReplyInput(link, title, root) {
    var post;
    if (root) {
        post = document.getElementById("${namespace}-reply-form");
    } else {
        post = $JQry(link).parents(".post")[0];
    }
    var input = $JQry(post).find(".reply-input");
    var hidden = (input.css("display") == "none");

    closeReplyInput();
    
    if (hidden) {
        var inputTitle = input.find(".reply-title").find("input")[0];
        inputTitle.value = "Re: " + title;

        var inputContent = input.find(".reply-content").find("textarea")[0];
        inputContent.value = "";

        input.toggle("fast");
    }
}


function closeReplyInput() {
    $JQry(".reply-input").toggle(false);
}


function selectCommentToDelete(id) {
    var formulaire = document.getElementById("${namespace}-delete-form");
    formulaire.action = "${deleteActionURL}&id=" + id;
    return false;
}
</script>
