/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.plugin.player;

import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import java.util.HashMap;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.player.Player;

public class ForumPlayer
implements INuxeoPlayerModule {
    public ForumPlayer(PortletContext portletContext) {
    }

    private String createForumPlayerRequest(DocumentContext<Document> docCtx) {
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        StringBuilder request = new StringBuilder();
        request.append("ecm:parentId = '").append(navigationInfos.getLiveId()).append("' ");
        request.append("AND ecm:primaryType IN ('Forum', 'Thread') ");
        request.append("ORDER BY ttcth:lastCommentDate DESC, dc:title ASC");
        return request.toString();
    }

    private Player getForumPlayer(DocumentContext<Document> docCtx) {
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createForumPlayerRequest(docCtx));
        windowProperties.put("osivia.cms.style", "forum");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        if (docCtx.getDoc() != null) {
            windowProperties.put("osivia.createParentPath", ((Document)docCtx.getDoc()).getPath());
        }
        windowProperties.put("osivia.cms.maxItems", "2000");
        windowProperties.put("osivia.cms.pageSizeMax", "2000");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    private Player getForumThreadPlayer(DocumentContext<Document> docCtx) {
        Document document = (Document)docCtx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-forum-portletInstance");
        return linkProps;
    }

    public Player getCMSPlayer(DocumentContext<Document> docCtx) {
        Document doc = (Document)docCtx.getDoc();
        if ("Forum".equals(doc.getType())) {
            return this.getForumPlayer(docCtx);
        }
        if ("Thread".equals(doc.getType())) {
            return this.getForumThreadPlayer(docCtx);
        }
        return null;
    }
}

