/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CommentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentAttachmentDTO;
import fr.toutatice.portail.cms.nuxeo.api.domain.ThreadPostDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.tag.INuxeoTagService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.services.forum.portlets.model.Thread;
import org.osivia.services.forum.portlets.model.ThreadObject;
import org.osivia.services.forum.portlets.model.ThreadPost;
import org.osivia.services.forum.portlets.model.ThreadPostReplyForm;
import org.osivia.services.forum.portlets.service.IForumService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ForumServiceImpl
implements IForumService,
ApplicationContextAware {
    private static final String DOCUMENT_REQUEST_ATTRIBUTE = "osivia.forum.document";
    @Autowired
    private INuxeoService nuxeoService;
    @Autowired
    private PersonService personService;
    private ApplicationContext applicationContext;

    public Document getDocument(NuxeoController nuxeoController) throws PortletException {
        try {
            Document document = (Document)nuxeoController.getRequest().getAttribute(DOCUMENT_REQUEST_ATTRIBUTE);
            if (document == null) {
                PortletRequest request = nuxeoController.getRequest();
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String path = window.getProperty("osivia.cms.uri");
                NuxeoDocumentContext nuxeoDocumentContext = nuxeoController.getDocumentContext(path);
                document = nuxeoDocumentContext.getDoc();
                nuxeoController.getRequest().setAttribute(DOCUMENT_REQUEST_ATTRIBUTE, (Object)document);
            }
            return document;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void generateAttachments(NuxeoController nuxeoController, Document document, Thread documentDTO) {
        List attachments = documentDTO.getAttachments();
        PropertyList files = document.getProperties().getList("files:files");
        if (files != null) {
            for (int i = 0; i < files.size(); ++i) {
                PropertyMap map = files.getMap(i);
                DocumentAttachmentDTO attachment = new DocumentAttachmentDTO();
                String name = map.getString("filename");
                attachment.setName(name);
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                attachment.setUrl(url);
                attachments.add(attachment);
            }
        }
    }

    public Thread getThread(NuxeoController nuxeoController) throws PortletException {
        Document document = this.getDocument(nuxeoController);
        Thread viewObject = this.toViewObject(nuxeoController, document);
        this.generateAttachments(nuxeoController, document, viewObject);
        return viewObject;
    }

    public List<ThreadPost> getThreadPosts(NuxeoController nuxeoController) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            List postsDTO = commentsService.getForumThreadPosts(cmsContext, document);
            ArrayList<ThreadPost> posts = new ArrayList<ThreadPost>(postsDTO.size());
            for (ThreadPostDTO postDTO : postsDTO) {
                ThreadPost post = this.toViewObject(nuxeoController, postDTO);
                posts.add(post);
            }
            return posts;
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void addThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, ThreadPostReplyForm replyForm, String parentId) throws PortletException {
        try {
            ThreadPostDTO post = this.toBusinessObject(replyForm);
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.addDocumentComment(cmsContext, document, (CommentDTO)post, parentId);
            posts.clear();
            posts.addAll(this.getThreadPosts(nuxeoController));
            replyForm.setContent(null);
            replyForm.setAttachment(null);
        }
        catch (PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void deleteThreadPost(NuxeoController nuxeoController, List<ThreadPost> posts, String id) throws PortletException {
        try {
            CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
            Document document = this.getDocument(nuxeoController);
            INuxeoCommentsService commentsService = nuxeoController.getNuxeoCommentsService();
            commentsService.deleteDocumentComment(cmsContext, document, id);
            this.deleteThreadPostFromModel(posts, id);
            posts.clear();
            posts.addAll(this.getThreadPosts(nuxeoController));
        }
        catch (CMSException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean deleteThreadPostFromModel(List<ThreadPost> posts, String id) {
        boolean deleted = false;
        for (ThreadPost post : posts) {
            if (id.equals(post.getId())) {
                deleted = posts.remove(post);
                break;
            }
            if (post.getChildren() == null || !(deleted = this.deleteThreadPostFromModel(post.getChildren(), id))) continue;
            break;
        }
        return deleted;
    }

    private Thread toViewObject(NuxeoController nuxeoController, Document document) throws PortletException {
        try {
            Thread vo = (Thread)this.applicationContext.getBean(Thread.class);
            vo.setAuthor(document.getString("dc:creator"));
            vo.setMessage(document.getString("ttcth:message"));
            Date date = document.getDate("dc:created");
            vo.setDate(date);
            boolean isCommentable = this.isThreadCommentable(nuxeoController, document);
            vo.setCommentable(isCommentable);
            Person person = this.personService.getPerson(vo.getAuthor());
            vo.setPerson(person);
            if (person != null) {
                INuxeoTagService tagService = this.nuxeoService.getTagService();
                String displayName = StringUtils.defaultIfEmpty((String)person.getDisplayName(), (String)vo.getAuthor());
                Link link = tagService.getUserProfileLink(nuxeoController, vo.getAuthor(), displayName);
                vo.setProfileUrl(link.getUrl());
            }
            return vo;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private ThreadPost toViewObject(NuxeoController nuxeoController, ThreadPostDTO dto) throws PortletException {
        try {
            ThreadPost vo = (ThreadPost)this.applicationContext.getBean(ThreadPost.class);
            BeanUtils.copyProperties((Object)vo, (Object)dto);
            vo.setMessage(dto.getContent());
            vo.setDate(dto.getCreationDate());
            if (dto.getFilename() != null) {
                vo.setAttachmentName(dto.getFilename());
                String attachmentURL = nuxeoController.createFileLink(dto.getPath(), "post:fileContent", dto.getFilename());
                vo.setAttachmentURL(attachmentURL);
            }
            this.addDirectoryPerson(nuxeoController, (ThreadObject)vo);
            for (CommentDTO child : dto.getChildren()) {
                if (!(child instanceof ThreadPostDTO)) continue;
                ThreadPostDTO childDTO = (ThreadPostDTO)child;
                ThreadPost childVO = this.toViewObject(nuxeoController, childDTO);
                vo.getChildren().add(childVO);
            }
            return vo;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void addDirectoryPerson(NuxeoController nuxeoController, ThreadObject vo) {
        Person person = this.personService.getPerson(vo.getAuthor());
        vo.setPerson(person);
        if (person != null) {
            INuxeoTagService tagService = this.nuxeoService.getTagService();
            String displayName = StringUtils.defaultIfBlank((String)person.getDisplayName(), (String)vo.getAuthor());
            Link link = tagService.getUserProfileLink(nuxeoController, vo.getAuthor(), displayName);
            vo.setProfileUrl(link.getUrl());
        }
    }

    private ThreadPostDTO toBusinessObject(ThreadPostReplyForm replyForm) throws PortletException {
        try {
            ThreadPostDTO post = new ThreadPostDTO();
            BeanUtils.copyProperties((Object)post, (Object)replyForm);
            MultipartFile attachmentMultipart = replyForm.getAttachment();
            if (attachmentMultipart != null && attachmentMultipart.getSize() > 0L) {
                File attachment = File.createTempFile("attachment", null);
                attachment.deleteOnExit();
                attachmentMultipart.transferTo(attachment);
                post.setAttachment(attachment);
                post.setFilename(attachmentMultipart.getOriginalFilename());
            } else {
                post.setAttachment(null);
            }
            return post;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private boolean isThreadCommentable(NuxeoController nuxeoController, Document document) throws CMSException {
        ICMSService cmsService = NuxeoController.getCMSService();
        CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(nuxeoController.getCMSCtx(), document.getPath());
        return publicationInfos.isCommentableByUser();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

