/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.edition.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.forum.edition.portlet.model.ForumEditionForm;
import org.osivia.services.forum.edition.portlet.model.ForumEditionOptions;
import org.osivia.services.forum.edition.portlet.model.validator.ForumEditionFormValidator;
import org.osivia.services.forum.edition.portlet.service.ForumEditionService;
import org.osivia.services.forum.util.controller.AbstractForumController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form", "options"})
public class ForumEditionController
extends AbstractForumController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private ForumEditionService service;
    @Autowired
    private ForumEditionFormValidator formValidator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="options") ForumEditionOptions options) throws PortletException {
        String title = options.getTitle();
        response.setTitle(title);
        return options.getViewPath();
    }

    @ActionMapping(name="save", params={"upload-vignette"})
    public void uploadVignette(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadVignette(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"delete-vignette"})
    public void deleteVignette(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteVignette(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"upload-attachment"})
    public void uploadAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"delete-attachment"})
    public void deleteAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"save"})
    public void save(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") @Validated ForumEditionForm form, BindingResult result, @ModelAttribute(value="options") ForumEditionOptions options) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.save(portalControllerContext, form, options);
        }
    }

    @ActionMapping(value="cancel")
    public void cancel(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") ForumEditionOptions options) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.cancel(portalControllerContext, options);
    }

    @ResourceMapping(value="vignettePreview")
    public void vignettePreview(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") ForumEditionForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.vignettePreview(portalControllerContext, form);
    }

    @ModelAttribute(value="form")
    public ForumEditionForm getForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
        binder.setDisallowedFields(new String[]{"documentType"});
    }

    @ModelAttribute(value="options")
    public ForumEditionOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }
}

