/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.model;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.portlet.PortletException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.cyberneko.html.parsers.SAXParser;
import org.dom4j.Element;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParserAction;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Component
public class ForumThreadParser {
    private static final String XSL_PATH = "/WEB-INF/xsl/forum-thread.xsl";
    @Autowired
    private ApplicationContext applicationContext;
    private final Templates templates = this.getTemplates();

    private Templates getTemplates() throws PortletException {
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource source = new StreamSource(this.getClass().getResourceAsStream(XSL_PATH));
        try {
            return factory.newTemplates(source);
        }
        catch (TransformerConfigurationException e) {
            throw new PortletException((Throwable)e);
        }
    }

    public String parse(PortalControllerContext portalControllerContext, String content, ForumThreadParserAction action) throws PortletException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Element element = DOM4JUtils.generateElement((String)"div", null, (String)content);
        String protectedElement = DOM4JUtils.writeCompact((Element)element);
        try {
            ForumThreadParserContext parserContext = (ForumThreadParserContext)this.applicationContext.getBean(ForumThreadParserContext.class, new Object[]{portalControllerContext});
            Transformer transformer = this.templates.newTransformer();
            transformer.setParameter("parserContext", parserContext);
            transformer.setParameter("action", action.getId());
            XMLReader parser = XMLReaderFactory.createXMLReader(SAXParser.class.getName());
            SAXSource source = new SAXSource(parser, new InputSource(new StringReader(protectedElement)));
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
            String string = ((Object)output).toString();
            return string;
        }
        catch (TransformerException | SAXException e) {
            throw new PortletException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

