/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPermissions;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.HasFile;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.forum.thread.portlet.model.ForumThreadForm;
import org.osivia.services.forum.thread.portlet.model.ForumThreadObject;
import org.osivia.services.forum.thread.portlet.model.ForumThreadOptions;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParser;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParserAction;
import org.osivia.services.forum.thread.portlet.model.ForumThreadPosts;
import org.osivia.services.forum.thread.portlet.repository.ForumThreadRepository;
import org.osivia.services.forum.thread.portlet.repository.command.CreateForumThreadPostCommand;
import org.osivia.services.forum.thread.portlet.repository.command.DeleteForumThreadPostCommand;
import org.osivia.services.forum.thread.portlet.repository.command.GetForumThreadPostsCommand;
import org.osivia.services.forum.thread.portlet.repository.command.ToggleForumThreadClosure;
import org.osivia.services.forum.thread.portlet.repository.command.UpdateForumThreadPostCommand;
import org.osivia.services.forum.util.model.ForumFile;
import org.osivia.services.forum.util.model.ForumFiles;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class ForumThreadRepositoryImpl
implements ForumThreadRepository {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ForumThreadParser parser;

    public void insertMenubarItems(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setCurrentDoc(document);
        nuxeoController.insertContentMenuBarItems();
    }

    public boolean isClosed(PortalControllerContext portalControllerContext, Document thread) throws PortletException {
        return thread.getProperties().getBoolean("ttc:commentsForbidden", Boolean.valueOf(false));
    }

    public ForumThreadObject updatePost(PortalControllerContext portalControllerContext, ForumThreadObject post, ForumThreadOptions options) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        String id = post.getId();
        String message = this.parser.parse(portalControllerContext, post.getMessage(), ForumThreadParserAction.SAVE);
        ForumFiles attachments = post.getAttachments();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(UpdateForumThreadPostCommand.class, new Object[]{id, message, attachments});
        nuxeoController.executeNuxeoCommand(command);
        ForumThreadPosts posts = this.getThreadPosts(portalControllerContext, options.getDocument());
        ForumThreadObject updatedPost = null;
        for (ForumThreadObject p : posts.getList()) {
            if (!StringUtils.equals((String)post.getId(), (String)p.getId())) continue;
            updatedPost = p;
            break;
        }
        return updatedPost;
    }

    public void deletePost(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Document document = options.getDocument();
        String id = form.getPosts().getDeletedId();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(DeleteForumThreadPostCommand.class, new Object[]{document, id});
        nuxeoController.executeNuxeoCommand(command);
    }

    public ForumThreadObject createPost(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException, IOException {
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        Document document = options.getDocument();
        String author = request.getRemoteUser();
        String message = this.parser.parse(portalControllerContext, form.getReply().getMessage(), ForumThreadParserAction.SAVE);
        ForumFiles attachments = form.getReply().getAttachments();
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(CreateForumThreadPostCommand.class, new Object[]{document, author, message, attachments});
        Document postDocument = (Document)nuxeoController.executeNuxeoCommand(command);
        String postId = postDocument.getId();
        ForumThreadPosts posts = this.getThreadPosts(portalControllerContext, options.getDocument());
        ForumThreadObject addedPost = null;
        for (ForumThreadObject post : posts.getList()) {
            if (!StringUtils.equals((String)postId, (String)post.getId())) continue;
            addedPost = post;
            break;
        }
        return addedPost;
    }

    public Document toggleThreadClosure(PortalControllerContext portalControllerContext, Document thread, boolean close) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(ToggleForumThreadClosure.class, new Object[]{thread, close});
        nuxeoController.executeNuxeoCommand(command);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        documentContext.reload();
        return documentContext.getDocument();
    }

    public void setProperties(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        Document document = documentContext.getDocument();
        NuxeoPermissions permissions = documentContext.getPermissions();
        ForumThreadObject thread = this.getThread(nuxeoController, document);
        form.setThread(thread);
        ForumThreadPosts posts = this.getThreadPosts(portalControllerContext, document);
        form.setPosts(posts);
        ForumThreadObject reply = this.getThreadReply(nuxeoController);
        form.setReply(reply);
        boolean commentable = permissions.isCommentable();
        form.setCommentable(commentable);
    }

    public Document getThread(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();
        return documentContext.getDocument();
    }

    public JSONArray getPosts(PortalControllerContext portalControllerContext, Document thread) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(GetForumThreadPostsCommand.class, new Object[]{thread});
        Blob blob = (Blob)nuxeoController.executeNuxeoCommand(command);
        String json = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
        if (blob instanceof HasFile) {
            HasFile hasFile = (HasFile)blob;
            hasFile.getFile().delete();
        }
        return JSONArray.fromObject((Object)json);
    }

    private ForumThreadObject getThread(NuxeoController nuxeoController, Document document) throws PortletException {
        ForumThreadObject thread = (ForumThreadObject)this.applicationContext.getBean(ForumThreadObject.class);
        String id = document.getId();
        thread.setId(id);
        String user = document.getString("dc:creator");
        thread.setUser(user);
        Date date = document.getDate("dc:created");
        thread.setDate(date);
        Date modified = document.getDate("dc:modified");
        if (Math.abs(modified.getTime() - date.getTime()) > TimeUnit.MINUTES.toMillis(1L)) {
            thread.setDate(date);
        }
        String message = document.getString("ttcth:message");
        thread.setMessage(message);
        ForumFiles attachments = (ForumFiles)this.applicationContext.getBean(ForumFiles.class);
        thread.setAttachments(attachments);
        PropertyList attachmentsList = document.getProperties().getList("files:files");
        if (attachmentsList != null) {
            ArrayList<ForumFile> files = new ArrayList<ForumFile>(attachmentsList.size());
            for (int i = 0; i < attachmentsList.size(); ++i) {
                PropertyMap map = attachmentsList.getMap(i);
                PropertyMap fileMap = map.getMap("file");
                ForumFile file = (ForumFile)this.applicationContext.getBean(ForumFile.class);
                String fileName = fileMap.getString("name");
                file.setFileName(fileName);
                String url = nuxeoController.createAttachedFileLink(document.getPath(), String.valueOf(i));
                file.setUrl(url);
                files.add(file);
            }
            attachments.setFiles(files);
        }
        return thread;
    }

    private ForumThreadPosts getThreadPosts(PortalControllerContext portalControllerContext, Document document) throws PortletException, IOException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        JSONArray array = this.getPosts(portalControllerContext, document);
        ForumThreadPosts posts = (ForumThreadPosts)this.applicationContext.getBean(ForumThreadPosts.class);
        List list = this.toPosts(nuxeoController, array);
        posts.setList(list);
        return posts;
    }

    private List<ForumThreadObject> toPosts(NuxeoController nuxeoController, JSONArray array) throws PortletException {
        ArrayList<ForumThreadObject> posts = new ArrayList<ForumThreadObject>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JSONObject object = array.getJSONObject(i);
            ForumThreadObject post = this.toPost(nuxeoController, object);
            posts.add(post);
        }
        return posts;
    }

    private ForumThreadObject toPost(NuxeoController nuxeoController, JSONObject object) throws PortletException {
        ForumThreadObject post = (ForumThreadObject)this.applicationContext.getBean(ForumThreadObject.class);
        String id = object.getString("id");
        post.setId(id);
        String user = object.getString("author");
        post.setUser(user);
        JSONObject dateObject = object.getJSONObject("creationDate");
        Long dateTime = dateObject.getLong("timeInMillis");
        Date date = new Date(dateTime);
        post.setDate(date);
        JSONObject modifiedObject = object.getJSONObject("modifiedDate");
        Long modifiedTime = modifiedObject.getLong("timeInMillis");
        if (Math.abs(modifiedTime - dateTime) > TimeUnit.MINUTES.toMillis(1L)) {
            Date modified = new Date(modifiedTime);
            post.setModified(modified);
        }
        String message = this.parser.parse(nuxeoController.getPortalCtx(), object.getString("content"), ForumThreadParserAction.LOAD);
        post.setMessage(message);
        ForumFiles attachments = this.getAttachments(nuxeoController, object);
        post.setAttachments(attachments);
        boolean editable = object.getBoolean("canDelete");
        post.setEditable(editable);
        return post;
    }

    private ForumFiles getAttachments(NuxeoController nuxeoController, JSONObject threadObject) {
        JSONArray attachmentsArray = threadObject.getJSONArray("files");
        ForumFiles attachments = (ForumFiles)this.applicationContext.getBean(ForumFiles.class);
        ArrayList<ForumFile> files = new ArrayList<ForumFile>(attachmentsArray.size());
        for (int i = 0; i < attachmentsArray.size(); ++i) {
            JSONObject attachmentObject = attachmentsArray.getJSONObject(i);
            ForumFile file = (ForumFile)this.applicationContext.getBean(ForumFile.class);
            String index = attachmentObject.getString("index");
            file.setBlobIndex(Integer.valueOf(NumberUtils.toInt((String)index)));
            String fileName = attachmentObject.getString("filename");
            file.setFileName(fileName);
            String url = nuxeoController.createAttachedFileLink(threadObject.getString("path"), index);
            file.setUrl(url);
            files.add(file);
        }
        attachments.setFiles(files);
        return attachments;
    }

    private ForumThreadObject getThreadReply(NuxeoController nuxeoController) throws PortletException {
        PortletRequest request = nuxeoController.getRequest();
        ForumThreadObject reply = (ForumThreadObject)this.applicationContext.getBean(ForumThreadObject.class);
        String user = request.getRemoteUser();
        reply.setUser(user);
        return reply;
    }
}

