/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.edition.portlet.model.validator;

import javax.activation.MimeType;
import org.osivia.services.forum.edition.portlet.model.ForumEditionForm;
import org.osivia.services.forum.edition.portlet.model.Vignette;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class ForumEditionFormValidator
implements Validator {
    private static final String IMAGE_MIME_PRIMARY_TYPE = "image";

    public boolean supports(Class<?> clazz) {
        return ForumEditionForm.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        MimeType mimeType;
        ForumEditionForm form = (ForumEditionForm)target;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"title", (String)"NotEmpty");
        Vignette vignette = form.getVignette();
        if (!(vignette.getTemporaryFile() == null || (mimeType = vignette.getMimeType()) != null && IMAGE_MIME_PRIMARY_TYPE.equals(mimeType.getPrimaryType()))) {
            errors.rejectValue("vignette.upload", "InvalidType");
        }
        if ("Thread".equals(form.getDocumentType())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"message", (String)"NotEmpty");
        }
    }
}

