/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.edition.portlet.repository.command;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.services.forum.edition.portlet.model.ForumEditionForm;
import org.osivia.services.forum.edition.portlet.model.ForumEditionMode;
import org.osivia.services.forum.edition.portlet.model.ForumEditionOptions;
import org.osivia.services.forum.edition.portlet.model.Vignette;
import org.osivia.services.forum.util.model.ForumFiles;
import org.osivia.services.forum.util.repository.command.AbstractForumCommand;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ForumEditionCommand
extends AbstractForumCommand {
    private static final String SHOW_IN_MENU_PROPERTY = "ttc:showInMenu";
    private final ForumEditionForm form;
    private final ForumEditionOptions options;

    public ForumEditionCommand(ForumEditionForm form, ForumEditionOptions options) {
        this.form = form;
        this.options = options;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        ForumEditionMode mode = this.options.getMode();
        Object document = ForumEditionMode.CREATION.equals((Object)mode) ? this.create(nuxeoSession) : (ForumEditionMode.EDITION.equals((Object)mode) ? this.edit(nuxeoSession) : null);
        return document;
    }

    public String getId() {
        return null;
    }

    private Document create(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocumentType documentType = this.options.getDocumentType();
        DocRef parent = new DocRef(this.options.getParentPath());
        String type = documentType.getName();
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", this.form.getTitle());
        if (StringUtils.isNotBlank((String)this.form.getDescription())) {
            properties.set("dc:description", this.form.getDescription());
        }
        if ("Thread".equals(type)) {
            properties.set("ttcth:message", this.form.getMessage());
        }
        properties.set(SHOW_IN_MENU_PROPERTY, Boolean.valueOf(documentType.isNavigable()));
        Document document = documentService.createDocument(parent, type, null, properties, true);
        Vignette vignette = this.form.getVignette();
        if (vignette.getTemporaryFile() != null) {
            FileBlob blob = new FileBlob(vignette.getTemporaryFile());
            documentService.setBlob((DocRef)document, (Blob)blob, "ttc:vignette");
            vignette.getTemporaryFile().delete();
        }
        if ("Thread".equals(type)) {
            ForumFiles attachments = this.form.getAttachments();
            this.setBlobs(documentService, (DocRef)document, attachments);
        }
        return document;
    }

    private Document edit(Session nuxeoSession) throws Exception {
        Vignette vignette;
        File temporaryFile;
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document document = this.options.getDocument();
        documentService.setProperty((DocRef)document, "dc:title", this.form.getTitle());
        documentService.setProperty((DocRef)document, "dc:description", this.form.getDescription());
        if ("Thread".equals(document.getType())) {
            documentService.setProperty((DocRef)document, "ttcth:message", this.form.getMessage());
        }
        if ((temporaryFile = (vignette = this.form.getVignette()).getTemporaryFile()) != null) {
            FileBlob blob = new FileBlob(temporaryFile);
            documentService.setBlob((DocRef)document, (Blob)blob, "ttc:vignette");
            temporaryFile.delete();
        } else if (vignette.isDeleted()) {
            documentService.removeBlob((DocRef)document, "ttc:vignette");
        }
        if ("Thread".equals(document.getType())) {
            ForumFiles attachments = this.form.getAttachments();
            this.setBlobs(documentService, (DocRef)document, attachments);
        }
        return document;
    }
}

