/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.plugin.player;

import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import java.util.HashMap;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.player.Player;

public class ForumPlayer
implements INuxeoPlayerModule {
    private static final String FORUM_PORTLET_INSTANCE = "toutatice-portail-cms-nuxeo-viewListPortletInstance";
    private static final String FORUM_THREAD_PORTLET_INSTANCE = "osivia-services-forum-thread-instance";

    public ForumPlayer(PortletContext portletContext) {
    }

    private String createForumPlayerRequest(NuxeoDocumentContext documentContext) {
        NuxeoPublicationInfos navigationInfos = documentContext.getPublicationInfos();
        StringBuilder request = new StringBuilder();
        request.append("ecm:parentId = '").append(navigationInfos.getLiveId()).append("' ");
        request.append("AND ecm:primaryType IN ('Forum', 'Thread') ");
        request.append("ORDER BY ttcth:lastCommentDate DESC, dc:title ASC");
        return request.toString();
    }

    private Player getForumPlayer(NuxeoDocumentContext documentContext) {
        Document document = documentContext.getDocument();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", document.getPath());
        properties.put("osivia.hideDecorators", "1");
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.cms.scope", documentContext.getScope());
        properties.put("osivia.cms.displayLiveVersion", documentContext.getDocumentState().toString());
        properties.put("osivia.nuxeoRequest", this.createForumPlayerRequest(documentContext));
        properties.put("osivia.cms.style", "forum");
        properties.put("osivia.createParentPath", document.getPath());
        properties.put("osivia.title", document.getTitle());
        properties.put("osivia.title.metadata", String.valueOf(true));
        Player player = new Player();
        player.setWindowProperties(properties);
        player.setPortletInstance(FORUM_PORTLET_INSTANCE);
        return player;
    }

    private Player getForumThreadPlayer(NuxeoDocumentContext documentContext) {
        Document document = documentContext.getDocument();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", document.getPath());
        properties.put("osivia.hideDecorators", "1");
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.title", document.getTitle());
        properties.put("osivia.title.metadata", String.valueOf(true));
        Player player = new Player();
        player.setWindowProperties(properties);
        player.setPortletInstance(FORUM_THREAD_PORTLET_INSTANCE);
        return player;
    }

    public Player getCMSPlayer(NuxeoDocumentContext documentContext) {
        Document doc = documentContext.getDocument();
        if ("Forum".equals(doc.getType())) {
            return this.getForumPlayer(documentContext);
        }
        if ("Thread".equals(doc.getType())) {
            return this.getForumThreadPlayer(documentContext);
        }
        return null;
    }
}

