/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.service;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.services.forum.thread.portlet.model.ForumThreadForm;
import org.osivia.services.forum.thread.portlet.model.ForumThreadObject;
import org.osivia.services.forum.thread.portlet.model.ForumThreadOptions;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParser;
import org.osivia.services.forum.thread.portlet.model.ForumThreadParserAction;
import org.osivia.services.forum.thread.portlet.model.ForumThreadPosts;
import org.osivia.services.forum.thread.portlet.repository.ForumThreadRepository;
import org.osivia.services.forum.thread.portlet.service.ForumThreadService;
import org.osivia.services.forum.util.model.ForumFile;
import org.osivia.services.forum.util.model.ForumFiles;
import org.osivia.services.forum.util.service.AbstractForumServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ForumThreadServiceImpl
extends AbstractForumServiceImpl
implements ForumThreadService {
    private static final String MENUBAR_ITEM_PREFIX = "FORUM_THREAD_MENUBAR_";
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ForumThreadRepository repository;
    @Autowired
    private ForumThreadParser parser;
    @Autowired
    private IMenubarService menubarService;
    @Autowired
    private IBundleFactory bundleFactory;

    public String view(PortalControllerContext portalControllerContext, ForumThreadOptions options) throws PortletException {
        PortletResponse response = portalControllerContext.getResponse();
        Document thread = options.getDocument();
        this.addMenubarItems(portalControllerContext, thread);
        this.repository.insertMenubarItems(portalControllerContext, thread);
        if (response instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)response;
            renderResponse.setTitle(thread.getTitle());
        }
        return "view";
    }

    private void addMenubarItems(PortalControllerContext portalControllerContext, Document thread) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        if (response instanceof MimeResponse) {
            String icon;
            String id;
            MimeResponse mimeResponse = (MimeResponse)response;
            List menubar = (List)request.getAttribute("osivia.menuBar");
            MenubarDropdown dropdown = this.menubarService.getDropdown(portalControllerContext, "OTHER_OPTIONS");
            if (dropdown == null) {
                dropdown = new MenubarDropdown("OTHER_OPTIONS", MenubarGroup.GENERIC);
            }
            int order = 14;
            PortletURL url = mimeResponse.createActionURL();
            if (this.repository.isClosed(portalControllerContext, thread)) {
                id = "FORUM_THREAD_MENUBAR_REOPEN";
                icon = "glyphicons glyphicons-unlock";
                url.setParameter("javax.portlet.action", "reopen");
                String indicatorId = "FORUM_THREAD_MENUBAR_CLOSED";
                MenubarItem indicator = new MenubarItem(indicatorId, bundle.getString(indicatorId), (MenubarContainer)MenubarGroup.SPECIFIC, 0, "label label-default");
                indicator.setGlyphicon("halflings halflings-lock");
                indicator.setState(true);
                menubar.add(indicator);
            } else {
                id = "FORUM_THREAD_MENUBAR_CLOSE";
                icon = "glyphicons glyphicons-lock";
                url.setParameter("javax.portlet.action", "close");
            }
            MenubarItem item = new MenubarItem(id, bundle.getString(id), icon, (MenubarContainer)dropdown, order, url.toString(), null, null, null);
            menubar.add(item);
        }
    }

    public void editPost(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException {
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject editedPost = null;
        for (ForumThreadObject post : posts.getList()) {
            if (!StringUtils.equals((String)posts.getEditedId(), (String)post.getId())) continue;
            editedPost = post.clone();
            break;
        }
        posts.setEditedPost(editedPost);
        posts.setEditedId(null);
    }

    public void uploadPostAttachment(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject editedPost = posts.getEditedPost();
        ForumFiles attachments = editedPost.getAttachments();
        this.uploadAttachments(attachments);
    }

    public void deletePostAttachment(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject editedPost = posts.getEditedPost();
        ForumFiles attachments = editedPost.getAttachments();
        this.deleteAttachment(attachments);
    }

    public void savePostEdition(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException, IOException {
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject editedPost = posts.getEditedPost();
        ForumThreadObject updatedPost = this.repository.updatePost(portalControllerContext, editedPost, options);
        for (ForumThreadObject post : posts.getList()) {
            if (!StringUtils.equals((String)updatedPost.getId(), (String)post.getId())) continue;
            try {
                BeanUtils.copyProperties((Object)post, (Object)updatedPost);
                break;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new PortletException((Throwable)e);
            }
        }
        posts.setEditedPost(null);
    }

    public void cancelPostEdition(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        ForumFiles attachments;
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject editedPost = posts.getEditedPost();
        if (editedPost != null && CollectionUtils.isNotEmpty((Collection)(attachments = editedPost.getAttachments()).getFiles())) {
            for (ForumFile file : attachments.getFiles()) {
                File temporaryFile = file.getTemporaryFile();
                if (temporaryFile == null) continue;
                temporaryFile.delete();
            }
        }
        posts.setEditedPost(null);
    }

    public void deletePost(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException {
        this.repository.deletePost(portalControllerContext, form, options);
        ForumThreadPosts posts = form.getPosts();
        ForumThreadObject deletedPost = null;
        for (ForumThreadObject post : posts.getList()) {
            if (!StringUtils.equals((String)posts.getDeletedId(), (String)post.getId())) continue;
            deletedPost = post;
            break;
        }
        if (deletedPost != null) {
            posts.getList().remove(deletedPost);
        }
        posts.setDeletedId(null);
    }

    public void uploadReplyAttachment(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        ForumThreadObject reply = form.getReply();
        ForumFiles attachments = reply.getAttachments();
        this.uploadAttachments(attachments);
    }

    public void deleteReplyAttachment(PortalControllerContext portalControllerContext, ForumThreadForm form) throws PortletException, IOException {
        ForumThreadObject reply = form.getReply();
        ForumFiles attachments = reply.getAttachments();
        this.deleteAttachment(attachments);
    }

    public void reply(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException, IOException {
        ForumThreadObject addedPost = this.repository.createPost(portalControllerContext, form, options);
        ArrayList<ForumThreadObject> list = form.getPosts().getList();
        if (list == null) {
            list = new ArrayList<ForumThreadObject>();
            form.getPosts().setList(list);
        }
        form.getReply().setMessage(null);
        form.getReply().setAttachments(null);
        if (addedPost != null) {
            list.add(addedPost);
        }
    }

    public void closeThread(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException {
        this.toggleThreadClosure(portalControllerContext, form, options, true);
    }

    public void reopenThread(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options) throws PortletException {
        this.toggleThreadClosure(portalControllerContext, form, options, false);
    }

    private void toggleThreadClosure(PortalControllerContext portalControllerContext, ForumThreadForm form, ForumThreadOptions options, boolean close) throws PortletException {
        Document thread = options.getDocument();
        Document updatedThread = this.repository.toggleThreadClosure(portalControllerContext, thread, close);
        form.setCommentable(!close);
        options.setDocument(updatedThread);
    }

    public void quote(PortalControllerContext portalControllerContext, ForumThreadForm form, String id) throws PortletException, IOException {
        PortletResponse portletResponse = portalControllerContext.getResponse();
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            ForumThreadObject object = null;
            if (StringUtils.equals((String)id, (String)form.getThread().getId())) {
                object = form.getThread();
            } else {
                for (ForumThreadObject post : form.getPosts().getList()) {
                    if (!StringUtils.equals((String)id, (String)post.getId())) continue;
                    object = post;
                    break;
                }
            }
            if (object != null) {
                String user = object.getUser();
                Element blockquote = DOM4JUtils.generateElement((String)"blockquote", null, (String)object.getMessage());
                DOM4JUtils.addDataAttribute((Element)blockquote, (String)"id", (String)id);
                DOM4JUtils.addDataAttribute((Element)blockquote, (String)"author", (String)user);
                Element emptyParagraph = DOM4JUtils.generateElement((String)"p", null, (String)"");
                mimeResponse.setContentType("text/html");
                PrintWriter printWriter = new PrintWriter(mimeResponse.getPortletOutputStream());
                printWriter.write(this.parser.parse(portalControllerContext, DOM4JUtils.writeCompact((Element)blockquote), ForumThreadParserAction.LOAD));
                printWriter.write(DOM4JUtils.writeCompact((Element)emptyParagraph));
                printWriter.close();
            }
        }
    }

    public ForumThreadForm getForm(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        ForumThreadForm form = (ForumThreadForm)this.applicationContext.getBean(ForumThreadForm.class);
        this.repository.setProperties(portalControllerContext, form);
        return form;
    }

    public ForumThreadOptions getOptions(PortalControllerContext portalControllerContext) throws PortletException {
        ForumThreadOptions options = (ForumThreadOptions)this.applicationContext.getBean(ForumThreadOptions.class);
        Document thread = this.repository.getThread(portalControllerContext);
        options.setDocument(thread);
        return options;
    }
}

