/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.repository.command;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.osivia.services.forum.util.model.ForumFiles;
import org.osivia.services.forum.util.repository.command.AbstractForumCommand;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CreateForumThreadPostCommand
extends AbstractForumCommand {
    private static final String OPERATION_REQUEST_ID = "Document.AddComment";
    private final Document document;
    private final String author;
    private final String message;
    private final ForumFiles attachments;

    public CreateForumThreadPostCommand(Document document, String author, String message, ForumFiles attachments) {
        this.document = document;
        this.author = author;
        this.message = message;
        this.attachments = attachments;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        List blobs;
        OperationRequest request = nuxeoSession.newRequest(OPERATION_REQUEST_ID);
        request.set("document", (Object)this.document);
        request.set("author", (Object)this.author);
        request.set("content", (Object)this.message);
        if (CollectionUtils.isNotEmpty((Collection)this.attachments.getFiles()) && !(blobs = this.getBlobs(this.attachments.getFiles())).isEmpty()) {
            request.setInput((OperationInput)new Blobs(blobs));
        }
        return request.execute();
    }

    public String getId() {
        return null;
    }
}

