/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.util.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.osivia.services.forum.util.model.ForumFile;
import org.osivia.services.forum.util.model.ForumFiles;

public abstract class AbstractForumCommand
implements INuxeoCommand {
    protected void setBlobs(DocumentService documentService, DocRef ref, ForumFiles attachments) throws Exception {
        List blobs;
        List files = attachments.getFiles();
        if (CollectionUtils.isNotEmpty((Collection)attachments.getDeletedBlobIndexes())) {
            for (Integer index : attachments.getDeletedBlobIndexes()) {
                StringBuilder xpath = new StringBuilder();
                xpath.append("files:files");
                xpath.append("/item[");
                xpath.append(index);
                xpath.append("]");
                documentService.removeBlob(ref, xpath.toString());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)files) && !(blobs = this.getBlobs(files)).isEmpty()) {
            documentService.setBlobs(ref, new Blobs(blobs), "files:files");
            for (ForumFile file : files) {
                if (file.getTemporaryFile() == null) continue;
                file.getTemporaryFile().delete();
            }
        }
    }

    public List<Blob> getBlobs(List<ForumFile> files) {
        ArrayList<Blob> blobs = new ArrayList<Blob>(files.size());
        for (ForumFile file : files) {
            File temporaryFile = file.getTemporaryFile();
            if (temporaryFile == null) continue;
            String fileName = file.getFileName();
            String mimeType = file.getMimeType().getBaseType();
            FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
            blobs.add((Blob)blob);
        }
        return blobs;
    }
}

