/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.forum.thread.portlet.controller;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.forum.thread.portlet.model.ForumThreadForm;
import org.osivia.services.forum.thread.portlet.model.ForumThreadOptions;
import org.osivia.services.forum.thread.portlet.model.validator.ForumThreadFormValidator;
import org.osivia.services.forum.thread.portlet.service.ForumThreadService;
import org.osivia.services.forum.util.controller.AbstractForumController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
@SessionAttributes(value={"form", "options"})
public class ThreadForumController
extends AbstractForumController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private ForumThreadService service;
    @Autowired
    private ForumThreadFormValidator formValidator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        return this.service.view(portalControllerContext, options);
    }

    @ActionMapping(name="save", params={"post-edit"})
    public void editPost(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.editPost(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"post-upload-attachment"})
    public void uploadPostAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadPostAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"post-delete-attachment"})
    public void deletePostAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deletePostAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"post-edition-save"})
    public void savePostEdition(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") @Validated ForumThreadForm form, BindingResult result, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.savePostEdition(portalControllerContext, form, options);
        }
    }

    @ActionMapping(name="save", params={"post-edition-cancel"})
    public void cancelPostEdition(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.cancelPostEdition(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"post-delete"})
    public void deletePost(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deletePost(portalControllerContext, form, options);
    }

    @ActionMapping(name="save", params={"reply-upload-attachment"})
    public void uploadReplyAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.uploadReplyAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"reply-delete-attachment"})
    public void deleteReplyAttachment(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.deleteReplyAttachment(portalControllerContext, form);
    }

    @ActionMapping(name="save", params={"reply-save"})
    public void reply(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") @Validated ForumThreadForm form, BindingResult result, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.reply(portalControllerContext, form, options);
        }
    }

    @ActionMapping(value="close")
    public void closeThread(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.closeThread(portalControllerContext, form, options);
    }

    @ActionMapping(value="reopen")
    public void reopenThread(ActionRequest request, ActionResponse response, @ModelAttribute(value="form") ForumThreadForm form, @ModelAttribute(value="options") ForumThreadOptions options) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.reopenThread(portalControllerContext, form, options);
    }

    @ResourceMapping(value="quote")
    public void quote(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="form") ForumThreadForm form, @RequestParam(value="id") String id) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.quote(portalControllerContext, form, id);
    }

    @ModelAttribute(value="form")
    public ForumThreadForm getForm(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getForm(portalControllerContext);
    }

    @InitBinder(value={"form"})
    public void formInitBinder(WebDataBinder binder) {
        binder.addValidators(new Validator[]{this.formValidator});
        binder.setDisallowedFields(new String[]{"commentable"});
    }

    @ModelAttribute(value="options")
    public ForumThreadOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ExceptionHandler(value={MultipartException.class})
    String handleFileException(Throwable ex, RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute("uploadMaxSize", (Object)ForumThreadService.MAX_UPLOAD_SIZE);
        return "upload-error";
    }
}

