/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;

public class GetUserJWTTokenCommand
implements INuxeoCommand {
    private final String algorithmId;

    public GetUserJWTTokenCommand(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String execute(Session nuxeoSession) throws Exception {
        OperationRequest newRequest = nuxeoSession.newRequest("UserGroup.GetJWTToken");
        newRequest.set("algorithmId", (Object)this.algorithmId);
        Blob tokenJsonBlob = (Blob)nuxeoSession.execute(newRequest);
        String token = "";
        if (tokenJsonBlob != null) {
            String tokenJson = IOUtils.toString((InputStream)tokenJsonBlob.getStream(), (String)"UTF-8");
            JSONObject jsonToken = JSONObject.fromObject((Object)tokenJson);
            token = jsonToken.getString("token");
        }
        return token;
    }

    public String getId() {
        return "GetUserJWTTokenCommand/" + this.algorithmId;
    }
}

