/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.portlet.controller;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.onlyoffice.portlet.service.IOnlyofficeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class OnlyofficeController
extends CMSPortlet
implements PortletContextAware,
PortletConfigAware {
    private static final String DEFAULT_VIEW = "view";
    private static final String CLOSE_VIEW = "close";
    private static final String ONLYOFFICE_DOMAIN = System.getProperty("osivia.onlyoffice.url", "");
    private static final String API_URL = ONLYOFFICE_DOMAIN + "/web-apps/apps/api/documents/api.js";
    private PortletContext portletContext;
    private PortletConfig portletConfig;
    @Autowired
    private IOnlyofficeService onlyofficeService;

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        NuxeoController nuxeoController;
        boolean askForLocking;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String action = window.getProperty("action");
        if (StringUtils.isNotEmpty((String)action) && CLOSE_VIEW.equals(action)) {
            return CLOSE_VIEW;
        }
        boolean withLock = Boolean.parseBoolean(window.getProperty("osivia.onlyoffice.withLock"));
        if (withLock && (askForLocking = this.onlyofficeService.askForLocking(nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext())))) {
            this.onlyofficeService.lockTemporary(nuxeoController);
        }
        return DEFAULT_VIEW;
    }

    @ActionMapping(params={"action=checkClosed"})
    public void checkClosed(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        try {
            boolean waitForRefresh;
            String documentId = window.getProperty("id");
            int timeout = 10;
            int i = 0;
            do {
                waitForRefresh = this.onlyofficeService.waitForRefresh(portalControllerContext, documentId);
                Thread.sleep(1000L);
            } while (waitForRefresh && ++i < timeout);
            String redirectionUrl = this.onlyofficeService.getCloseRedirectionUrl(portalControllerContext, documentId);
            if (StringUtils.isNotEmpty((String)redirectionUrl)) {
                response.sendRedirect(redirectionUrl);
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    @ModelAttribute(value="apiUrl")
    public String getApiUrl(PortletRequest portletRequest, PortletResponse portletResponse) {
        return API_URL;
    }

    @ModelAttribute(value="onlyOfficeConfig")
    public String getOnlyOfficeConfig(PortletRequest portletRequest, PortletResponse portletResponse) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portletRequest);
        String action = window.getProperty("action");
        String documentPath = window.getProperty("osivia.cms.uri");
        if (StringUtils.isEmpty((String)action)) {
            return this.onlyofficeService.getOnlyOfficeConfig(portletRequest, portletResponse, this.getPortletContext(), documentPath);
        }
        return null;
    }

    @ModelAttribute(value="toolbarProperties")
    public Map<String, String> getToolbarProperties(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.onlyofficeService.getToolbarProperties(portalControllerContext);
    }
}

