/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.onlyoffice.portlet.service.impl;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.LockStatus;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPermissions;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.liveedit.OnlyofficeLiveEditHelper;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.FileMimeType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.onlyoffice.portlet.command.GetUserJWTTokenCommand;
import org.osivia.services.onlyoffice.portlet.model.EditorConfig;
import org.osivia.services.onlyoffice.portlet.model.EditorConfigCustomization;
import org.osivia.services.onlyoffice.portlet.model.EditorConfigCustomizationGoback;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeDocument;
import org.osivia.services.onlyoffice.portlet.model.OnlyOfficeUser;
import org.osivia.services.onlyoffice.portlet.model.OnlyofficeConfig;
import org.osivia.services.onlyoffice.portlet.service.IOnlyofficeService;
import org.osivia.services.onlyoffice.portlet.service.impl.IsDocumentCurrentlyEditedCommand;
import org.osivia.services.onlyoffice.portlet.service.impl.LockTemporaryCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OnlyofficeImpl
implements IOnlyofficeService {
    @Value(value="#{systemProperties['osivia.onlyoffice.token.secret'] ?: null}")
    private String secret;
    private static final String ANONYMOUS_NAME = "Utilisateur invit\u00e9";
    private static final String ANONYMOUS_LOGIN = "Anonymous";
    private static final String WEBSERVICE_CALLBACKEDIT_PATH = "/site/onlyoffice/callbackEdit/";
    private static final String ONLYOFFICE_TOKEN_ID = System.getProperty("osivia.onlyoffice.token.id", "onlyoffice");
    private static final String ONLYOFFICE_NUXEO_URL = System.getProperty("osivia.onlyoffice.nuxeo.url", "");
    private static final String ONLYOFFICE_LANG = System.getProperty("osivia.onlyoffice.lang", "fr-FR");
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private INuxeoService nuxeoService;
    @Autowired
    private PersonService personService;

    private String getWindowProperty(PortletRequest request, String property) {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        return window.getProperty(property);
    }

    private PropertyMap getCurrentFileContent(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap properties = this.getCurrentProperties(portletRequest, portletResponse, portletContext);
        PropertyMap fileContent = properties.getMap("file:content");
        return fileContent;
    }

    private PropertyMap getCurrentProperties(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        PropertyMap properties = currentDoc.getProperties();
        return properties;
    }

    private Document getCurrentDoc(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        Document currentDoc = nuxeoController.getCurrentDoc();
        if (currentDoc == null) {
            String path = this.getWindowProperty(portletRequest, "osivia.cms.uri");
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
            currentDoc = documentContext.getDocument();
            nuxeoController.setCurrentDoc(currentDoc);
        }
        return currentDoc;
    }

    private String getMode(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext, String documentPath) throws PortletException {
        PortalControllerContext portalCtx = new PortalControllerContext(portletContext, portletRequest, portletResponse);
        NuxeoController ctl = new NuxeoController(portalCtx);
        NuxeoDocumentContext documentContext = ctl.getDocumentContext(documentPath);
        NuxeoPermissions permissions = documentContext.getPermissions();
        if (permissions.isEditable()) {
            return "edit";
        }
        return "view";
    }

    private String getDocUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String docUrl = fileContent.getString("data");
        NuxeoController nuxeoController = new NuxeoController(portletRequest, portletResponse, portletContext);
        String userToken = (String)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetUserJWTTokenCommand(ONLYOFFICE_TOKEN_ID));
        if (StringUtils.contains((String)docUrl, (String)"/nxbigfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxbigfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else if (StringUtils.contains((String)docUrl, (String)"/nxfile/")) {
            int indexOf = StringUtils.indexOf((String)docUrl, (String)"/nxfile/");
            docUrl = ONLYOFFICE_NUXEO_URL + StringUtils.substring((String)docUrl, (int)indexOf) + "?token=" + userToken;
        } else {
            docUrl = "";
        }
        return docUrl;
    }

    private String getDocFileType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        String filename = this.getDocTitle(portletRequest, portletResponse, portletContext);
        String docExtension = StringUtils.substringAfterLast((String)filename, (String)".");
        return docExtension;
    }

    private String getDocKey(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String docKey = currentDoc.getId() + "." + currentDoc.getLastModified().getTime();
        return docKey;
    }

    private String getDocTitle(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String filename = fileContent.getString("name");
        return filename;
    }

    private String getCallbackUrl(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        Document currentDoc = this.getCurrentDoc(portletRequest, portletResponse, portletContext);
        String currentDocId = currentDoc.getId();
        return ONLYOFFICE_NUXEO_URL + WEBSERVICE_CALLBACKEDIT_PATH + currentDocId;
    }

    private String getDocumentType(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PropertyMap fileContent = this.getCurrentFileContent(portletRequest, portletResponse, portletContext);
        String mimeType = fileContent.getString("mime-type");
        return OnlyofficeLiveEditHelper.getFileType((String)mimeType).name();
    }

    private EditorConfigCustomizationGoback getGoback(Bundle bundle, PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, portletRequest, portletResponse);
        EditorConfigCustomizationGoback goback = new EditorConfigCustomizationGoback();
        goback.setText(bundle.getString("BACK_TEXT"));
        String toCloseUrl = this.getCloseUrl(portalControllerContext);
        goback.setUrl(toCloseUrl);
        goback.setBlank(false);
        return goback;
    }

    public String getOnlyOfficeConfig(PortletRequest portletRequest, PortletResponse portletResponse, PortletContext portletContext, String documentPath) throws PortletException {
        OnlyofficeConfig onlyOfficeConfig = new OnlyofficeConfig();
        OnlyOfficeDocument onlyOfficeDocument = new OnlyOfficeDocument();
        onlyOfficeDocument.setFileType(this.getDocFileType(portletRequest, portletResponse, portletContext));
        onlyOfficeDocument.setKey(this.getDocKey(portletRequest, portletResponse, portletContext));
        String escapeTitle = this.getDocTitle(portletRequest, portletResponse, portletContext);
        onlyOfficeDocument.setTitle(escapeTitle.replaceAll("'", " "));
        String escapeUrl = this.getDocUrl(portletRequest, portletResponse, portletContext);
        onlyOfficeDocument.setUrl(escapeUrl.replaceAll("'", ""));
        onlyOfficeConfig.setDocument(onlyOfficeDocument);
        onlyOfficeConfig.setDocumentType(this.getDocumentType(portletRequest, portletResponse, portletContext));
        if (this.secret != null) {
            try {
                Algorithm algorithm = Algorithm.HMAC256((String)"secret");
                String token = JWT.create().sign(algorithm);
                onlyOfficeConfig.setToken(token);
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                throw new PortletException((Throwable)e);
            }
        }
        EditorConfig onlyOfficeEditorConfig = new EditorConfig();
        onlyOfficeEditorConfig.setCallbackUrl(this.getCallbackUrl(portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setUser(this.buildOnlyOfficeUser(portletRequest.getUserPrincipal()));
        onlyOfficeEditorConfig.setMode(this.getMode(portletRequest, portletResponse, portletContext, documentPath));
        onlyOfficeEditorConfig.setLang(this.getLang(portletRequest.getLocale()));
        EditorConfigCustomization editorConfigCustomization = new EditorConfigCustomization();
        editorConfigCustomization.setChat(true);
        editorConfigCustomization.setCompactToolbar(false);
        Bundle bundle = this.bundleFactory.getBundle(portletRequest.getLocale());
        editorConfigCustomization.setGoback(this.getGoback(bundle, portletRequest, portletResponse, portletContext));
        onlyOfficeEditorConfig.setCustomization(editorConfigCustomization);
        onlyOfficeConfig.setEditorConfig(onlyOfficeEditorConfig);
        JSONObject onlyOfficeConfigJson = JSONObject.fromObject((Object)onlyOfficeConfig);
        return onlyOfficeConfigJson.toString();
    }

    public Map<String, String> getToolbarProperties(PortalControllerContext portalControllerContext) throws PortletException, IOException {
        HashMap<String, String> properties;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        INuxeoCustomizer customizer = this.nuxeoService.getCMSCustomizer();
        String action = window.getProperty("action");
        if (StringUtils.isEmpty((String)action)) {
            properties = new HashMap<String, String>();
            Document document = this.getCurrentDoc(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
            properties.put("documentTitle", document.getTitle());
            PropertyMap fileContent = document.getProperties().getMap("file:content");
            FileMimeType fileMimeType = fileContent == null ? null : customizer.getFileMimeType(fileContent.getString("mime-type"));
            if (fileMimeType != null) {
                properties.put("extension", fileMimeType.getExtension());
            }
            String closeUrl = this.getCloseUrl(portalControllerContext);
            properties.put("closeUrl", closeUrl);
        } else {
            properties = null;
        }
        return properties;
    }

    private String getCloseUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String url;
        PortletRequest request = portalControllerContext.getRequest();
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        IPortalUrlFactory portalUrlFactory = nuxeoController.getPortalUrlFactory();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        Document document = this.getCurrentDoc(request, portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.title", bundle.getString("CLOSING"));
        properties.put("id", document.getId());
        properties.put("action", "close");
        try {
            url = portalUrlFactory.getStartPortletUrl(portalControllerContext, "osivia-services-onlyoffice-portletInstance", properties);
        }
        catch (PortalException e) {
            url = "";
        }
        return url;
    }

    private String getLang(Locale locale) {
        return ONLYOFFICE_LANG;
    }

    private OnlyOfficeUser buildOnlyOfficeUser(Principal userPrincipal) {
        OnlyOfficeUser user = new OnlyOfficeUser();
        String id = ANONYMOUS_LOGIN;
        if (userPrincipal != null) {
            id = userPrincipal.getName();
            Person person = this.personService.getPerson(id);
            if (person != null) {
                String displayName = person.getDisplayName().replace("'", " ");
                user.setName(displayName);
            } else {
                user.setName(id);
            }
        } else {
            user.setName(ANONYMOUS_NAME);
        }
        user.setId(id);
        return user;
    }

    public boolean waitForRefresh(PortalControllerContext pcc, String uuid) {
        JSONArray usernamesArray;
        JSONObject currentlyEditedEntry;
        boolean editedByMe = false;
        boolean editedByOthers = false;
        Principal principal = pcc.getRequest().getUserPrincipal();
        NuxeoController controller = new NuxeoController(pcc);
        IsDocumentCurrentlyEditedCommand command = new IsDocumentCurrentlyEditedCommand(uuid);
        JSONObject info = (JSONObject)controller.executeNuxeoCommand((INuxeoCommand)command);
        if (info != null && info.containsKey((Object)"isCurrentlyEdited") && info.getBoolean("isCurrentlyEdited") && (currentlyEditedEntry = info.getJSONObject("currentlyEditedEntry")) != null && (usernamesArray = currentlyEditedEntry.getJSONArray("username")) != null) {
            ListIterator userNamesI = usernamesArray.listIterator();
            while (userNamesI.hasNext()) {
                String userName = (String)userNamesI.next();
                if (principal != null && StringUtils.equals((String)principal.getName(), (String)userName)) {
                    editedByMe = true;
                    continue;
                }
                editedByOthers = true;
            }
        }
        return editedByMe && !editedByOthers;
    }

    public boolean askForLocking(NuxeoController nuxeoController) throws PortletException {
        NuxeoDocumentContext ctx = nuxeoController.getDocumentContext(this.getCurrentDoc(nuxeoController.getRequest(), nuxeoController.getResponse(), nuxeoController.getPortletCtx()).getPath());
        NuxeoPublicationInfos infos = ctx.getPublicationInfos();
        Bundle bundle = this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale());
        if (infos.isBeingModified()) {
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("CURRENTLY_EDITED"), NotificationsType.WARNING);
            return false;
        }
        if (infos.getLockStatus() != null && infos.getLockStatus().equals((Object)LockStatus.LOCKED)) {
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("CURRENTLY_LOCKED"), NotificationsType.WARNING);
            return false;
        }
        return true;
    }

    public void lockTemporary(NuxeoController nuxeoController) throws PortletException {
        Document currentDoc = this.getCurrentDoc(nuxeoController.getRequest(), nuxeoController.getResponse(), nuxeoController.getPortletCtx());
        LockTemporaryCommand command = new LockTemporaryCommand(currentDoc.getId());
        JSONObject info = (JSONObject)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        String error = info.getString("error");
        if ("1".equals(error)) {
            Bundle bundle = this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale());
            this.notificationsService.addSimpleNotification(nuxeoController.getPortalCtx(), bundle.getString("LOCK_ERROR"), NotificationsType.ERROR);
        }
    }

    public String getCloseRedirectionUrl(PortalControllerContext portalControllerContext, String documentId) {
        return this.portalUrlFactory.getCMSUrl(portalControllerContext, null, documentId, null, null, "refreshPageAndNavigation", null, null, null, null);
    }
}

