/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.pad.plugin;

import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.Permissions;
import org.osivia.portal.api.cms.PublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class PadMenubarModule
implements MenubarModule {
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IPortalUrlFactory portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final IBundleFactory bundleFactory;

    public PadMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        Permissions permissions;
        if (documentContext.getDocumentType().getName().equals("ToutaticePad") && (permissions = documentContext.getPermissions()).isEditable()) {
            HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
            Bundle bundle = this.bundleFactory.getBundle(servletRequest.getLocale());
            String title = bundle.getString("JOIN_PAD");
            String icon = "glyphicons glyphicons-pencil";
            MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
            int order = 1;
            HashMap requestParameters = new HashMap();
            PublicationInfos publicationInfos = documentContext.getPublicationInfos();
            String url = this.getEcmPadUrl(publicationInfos.getPath(), requestParameters);
            MenubarItem joinPad = new MenubarItem("JOIN_PAD", title, icon, (MenubarContainer)parent, order, url, null, null, "fancyframe_refresh");
            menubar.add(joinPad);
            MenubarItem edit = null;
            for (MenubarItem item : menubar) {
                if (!item.getId().equals("EDIT")) continue;
                edit = item;
            }
            if (edit != null) {
                menubar.remove(edit);
            }
        }
    }

    private String getEcmPadUrl(String path, Map<String, String> requestParameters) {
        String uri = NuxeoConnectionProperties.getPublicBaseUri().toString();
        String url = uri.toString() + "/nxpath/default" + path + "@toutapad_join_pad?";
        return url;
    }
}

