/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.procedure.formFilters.CreateRecordCommand;
import org.osivia.services.procedure.formFilters.RecordFormFilter;

public class CreateRecordFilter
extends RecordFormFilter {
    public static final String ID = "CreateRecordFilter";
    private static final String LABEL_KEY = "CREATE_RECORD_FILTER_LABEL";
    private static final String DESCRIPTION_KEY = "CREATE_RECORD_FILTER_DESCRIPTION";
    private static final String NOTIFICATION_KEY = "RECORD_CREATED_NOTIFICATION";
    private final IBundleFactory bundleFactory;

    public CreateRecordFilter() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        NuxeoController nuxeoController = new NuxeoController(context.getPortalControllerContext());
        String fetchPath = NuxeoController.webIdToFetchPath((String)context.getModelWebId());
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(fetchPath);
        Document recordFolder = documentContext.getDocument();
        PropertyMap properties = recordFolder.getProperties();
        PropertyList globalVariablesReferences = this.getGlobalVariablesReferences("formulaire", properties);
        PropertyMap createProperties = new PropertyMap();
        HashMap variables = new HashMap();
        for (Object variableREfO : globalVariablesReferences.list()) {
            PropertyMap variableREfM = (PropertyMap)variableREfO;
            String variableName = variableREfM.getString("variableName");
            variables.put(variableName, context.getVariables().get(variableName));
        }
        createProperties.set("rcd:globalVariablesValues", this.generateVariablesJSON(variables));
        createProperties.set("rcd:procedureModelWebId", context.getModelWebId());
        createProperties.set("dc:title", recordFolder.getTitle());
        Document createdRecord = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateRecordCommand(new DocRef(recordFolder.getPath()), createProperties, recordFolder.getTitle()));
        context.getVariables().put("_redirectCmsPath", recordFolder.getPath());
        context.getVariables().put("_displayContext", "menu");
        context.getVariables().put("_notificationMessage", this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale()).getString(NOTIFICATION_KEY));
    }
}

