/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.procedure.formFilters.DeleteRecordCommand;

public class DeleteRecordFilter
implements FormFilter {
    public static final String ID = "DeleteRecordFilter";
    public static final String LABEL_KEY = "DELETE_RECORD_FILTER_LABEL";
    public static final String DESCRIPTION_KEY = "DELETE_RECORD_FILTER_DESCRIPTION";
    private static final String NOTIFICATION_KEY = "RECORD_DELETED_NOTIFICATION";
    private final IBundleFactory bundleFactory;

    public DeleteRecordFilter() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        NuxeoController nuxeoController = new NuxeoController(context.getPortalControllerContext());
        nuxeoController.executeNuxeoCommand((INuxeoCommand)new DeleteRecordCommand(new DocRef((String)context.getVariables().get("rcdPath"))));
        context.getVariables().put("_redirectCmsPath", context.getVariables().get("rcdFolderPath"));
        context.getVariables().put("_displayContext", "menu");
        context.getVariables().put("_notificationMessage", this.bundleFactory.getBundle(nuxeoController.getRequest().getLocale()).getString(NOTIFICATION_KEY));
    }
}

