/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.formFilters;

import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.Name;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.directory.v2.service.PersonService;

public class SetInitiatorVariableFilter
implements FormFilter {
    public static final String ID = "SET_INITIATOR_VARIABLE";
    private static final String LABEL_INTERNATIONALIZATION_KEY = "SET_INITIATOR_VARIABLE_LABEL";
    private static final String DESCRIPTION_INTERNATIONALIZATION_KEY = "SET_INITIATOR_VARIABLE_DESCRIPTION";
    private final PersonService dirService = (PersonService)DirServiceFactory.getService(PersonService.class);

    public String getId() {
        return ID;
    }

    public String getLabelKey() {
        return LABEL_INTERNATIONALIZATION_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_INTERNATIONALIZATION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        Person person;
        String procedureInitiator = context.getProcedureInitiator();
        if (StringUtils.isNotBlank((String)procedureInitiator) && (person = this.dirService.getPerson(procedureInitiator)) != null) {
            ArrayList<String> namesS = new ArrayList<String>();
            for (Name names : person.getProfiles()) {
                namesS.add(names.toString());
            }
            String profiles = StringUtils.join(namesS, (char)',');
            context.getVariables().put("procedureInitiator_avatarUrl", person.getAvatar().getUrl());
            context.getVariables().put("procedureInitiator_cn", person.getCn());
            context.getVariables().put("procedureInitiator_displayName", person.getDisplayName());
            context.getVariables().put("procedureInitiator_dn", person.getDn().toString());
            context.getVariables().put("procedureInitiator_givenName", person.getGivenName());
            context.getVariables().put("procedureInitiator_mail", person.getMail());
            context.getVariables().put("procedureInitiator_profiles", profiles);
            context.getVariables().put("procedureInitiator_sn", person.getSn());
            context.getVariables().put("procedureInitiator_title", person.getTitle());
        }
    }
}

