/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.AccessibilityRoles;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarDropdown;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;

public class ProcedureMenubarModule
implements MenubarModule {
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IBundleFactory bundleFactory;

    public ProcedureMenubarModule() {
        IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void customizeSpace(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext spaceDocumentContext) throws PortalException {
    }

    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext) throws PortalException {
        if (documentContext instanceof NuxeoDocumentContext) {
            documentContext = (NuxeoDocumentContext)documentContext;
            Document document = ((NuxeoDocumentContext)documentContext).getDocument();
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
            if (document != null && StringUtils.equals((String)document.getType(), (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
                String documentPath = document.getPath();
                String cmsUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, documentPath, null, null, "create", null, null, null, null);
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD_ELEMENT"), "halflings halflings-plus", (MenubarContainer)MenubarGroup.ADD, 0, cmsUrl, null, null, null);
                item.setAjaxDisabled(true);
                menubar.add(item);
                String webId = document.getProperties().getString("ttc:webid");
                HashMap<String, String> windowProperties = new HashMap<String, String>();
                windowProperties.put("osivia.doctype", DocumentTypeEnum.RECORDFOLDER.getDocType());
                windowProperties.put("osivia.hideDecorators", "1");
                windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
                windowProperties.put("osivia.ajaxLink", "1");
                windowProperties.put("osivia.procedure.admin", "adminrecord");
                windowProperties.put("osivia.services.procedure.webid", webId);
                windowProperties.put("osivia.title", bundle.getString("EDIT_PROCEDURE"));
                String editRecUrl = nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                item = new MenubarItem("EDIT", bundle.getString("EDIT_RECORD_FOLDER"), "halflings halflings-pencil", (MenubarContainer)parent, 0, editRecUrl, null, null, null);
                item.setAjaxDisabled(true);
                menubar.add(item);
                String itemLabel = bundle.getString("DELETE");
                item = new MenubarItem("DELETE", itemLabel, "glyphicons glyphicons-bin", (MenubarContainer)parent, 20, null, null, null, null);
                item.setAjaxDisabled(true);
                item.setDivider(true);
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put("docId", document.getId());
                properties.put("docPath", document.getPath());
                String fancyboxId = nuxeoController.getCMSCtx().getResponse().getNamespace() + "_PORTAL_DELETE";
                NuxeoPublicationInfos pubInfos = ((NuxeoDocumentContext)documentContext).getPublicationInfos();
                String removeURL = nuxeoController.getPortalUrlFactory().getPutDocumentInTrashUrl(portalControllerContext, pubInfos.getLiveId(), pubInfos.getPath());
                String fancybox = this.generateDeleteConfirmationFancybox(properties, bundle, fancyboxId, removeURL);
                item.setAssociatedHTML(fancybox);
                String url = "#" + fancyboxId;
                item.setUrl("javascript:;");
                item.getData().put("fancybox", "");
                item.getData().put("src", url);
                menubar.add(item);
            } else if (document != null && StringUtils.equals((String)document.getType(), (String)DocumentTypeEnum.RECORDCONTAINER.getDocType())) {
                String documentPath = document.getPath();
                HashMap<String, String> windowProperties = new HashMap<String, String>();
                windowProperties.put("osivia.doctype", DocumentTypeEnum.RECORDFOLDER.getDocType());
                windowProperties.put("osivia.services.procedure.procedurePath", documentPath);
                windowProperties.put("osivia.hideDecorators", "1");
                windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
                windowProperties.put("osivia.ajaxLink", "1");
                windowProperties.put("osivia.procedure.admin", "adminrecord");
                windowProperties.put("osivia.title", bundle.getString("CREATE_RECORD_FOLDER"));
                String addRecUrl = nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
                MenubarItem item = new MenubarItem("ADD", bundle.getString("ADD_RECORD_FOLDER"), "halflings halflings-plus", (MenubarContainer)MenubarGroup.ADD, 0, addRecUrl, null, null, null);
                item.setAjaxDisabled(true);
                menubar.add(item);
            } else if (document != null && StringUtils.equals((String)document.getType(), (String)DocumentTypeEnum.RECORD.getDocType())) {
                String documentPath = document.getPath();
                MenubarDropdown parent = this.menubarService.getDropdown(portalControllerContext, "CMS_EDITION");
                String cmsUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, documentPath, null, null, "edit", null, null, null, null);
                MenubarItem item = new MenubarItem("EDIT", bundle.getString("EDIT_RECORD"), "halflings halflings-pencil", (MenubarContainer)parent, 0, cmsUrl, null, null, null);
                item.setAjaxDisabled(true);
                menubar.add(item);
                cmsUrl = nuxeoController.getPortalUrlFactory().getCMSUrl(portalControllerContext, null, documentPath, null, null, "delete", null, null, null, null);
                item = new MenubarItem("EDIT", bundle.getString("DELETE_RECORD"), "halflings halflings-trash", (MenubarContainer)parent, 20, cmsUrl, null, null, null);
                item.setAjaxDisabled(true);
                item.setDivider(true);
                menubar.add(item);
            }
        }
    }

    private String generateDeleteConfirmationFancybox(Map<String, String> properties, Bundle bundle, String fancyboxId, String actionURL) {
        Element fancyboxContainer = DOM4JUtils.generateDivElement((String)"hidden");
        Element container = DOM4JUtils.generateDivElement(null);
        DOM4JUtils.addAttribute((Element)container, (String)"id", (String)fancyboxId);
        fancyboxContainer.add(container);
        Element form = DOM4JUtils.generateElement((String)"form", (String)"text-center", null, null, (AccessibilityRoles)AccessibilityRoles.FORM);
        DOM4JUtils.addAttribute((Element)form, (String)"action", (String)actionURL);
        DOM4JUtils.addAttribute((Element)form, (String)"method", (String)"post");
        container.add(form);
        Element message = DOM4JUtils.generateElement((String)"p", null, (String)bundle.getString("CMS_DELETE_CONFIRM_MESSAGE"));
        form.add(message);
        for (Map.Entry<String, String> property : properties.entrySet()) {
            Element hidden = DOM4JUtils.generateElement((String)"input", null, null);
            DOM4JUtils.addAttribute((Element)hidden, (String)"type", (String)"hidden");
            DOM4JUtils.addAttribute((Element)hidden, (String)"name", (String)property.getKey());
            DOM4JUtils.addAttribute((Element)hidden, (String)"value", (String)property.getValue());
            form.add(hidden);
        }
        Element okButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-warning", (String)bundle.getString("YES"), (String)"halflings halflings-alert", null);
        DOM4JUtils.addAttribute((Element)okButton, (String)"type", (String)"submit");
        form.add(okButton);
        Element cancelButton = DOM4JUtils.generateElement((String)"button", (String)"btn btn-default", (String)bundle.getString("NO"));
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"type", (String)"button");
        DOM4JUtils.addAttribute((Element)cancelButton, (String)"onclick", (String)"closeFancybox()");
        form.add(cancelButton);
        return DOM4JUtils.write((Element)fancyboxContainer);
    }
}

