/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.Filter;
import org.osivia.services.procedure.portlet.util.FiltersUtil;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Action {
    @JsonProperty(value="stepReference")
    private String stepReference;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="actionId")
    private String actionId;
    @JsonProperty(value="filtersList")
    private Set<Filter> filtersList;
    @JsonIgnore
    private List<Filter> filters;

    public Action() {
        this.filtersList = new HashSet();
        this.filters = new ArrayList();
    }

    public Action(String actionId) {
        this.filtersList = new HashSet();
        this.filters = new ArrayList();
        this.setActionId(actionId);
    }

    public Action(PropertyMap propertyMap, NuxeoController nuxeoController) {
        this.setLabel(propertyMap.getString("label"));
        this.setActionId(propertyMap.getString("actionId"));
        this.setStepReference(propertyMap.getString("stepReference"));
        this.filtersList = new HashSet();
        this.filters = new ArrayList();
        PropertyList filtersPList = propertyMap.getList("filtersList");
        if (filtersPList != null) {
            HashMap<String, Filter> filterMap = new HashMap<String, Filter>();
            for (Object fltrO : filtersPList.list()) {
                PropertyMap fltrMap = (PropertyMap)fltrO;
                Filter filter = new Filter(fltrMap, nuxeoController);
                filterMap.put(filter.getFilterPath(), filter);
                this.filtersList.add(filter);
            }
            boolean completed = false;
            int i = 0;
            while (!completed) {
                String fieldIndex = String.valueOf(i);
                Filter mapFilter = (Filter)filterMap.get(fieldIndex);
                if (mapFilter != null) {
                    FiltersUtil.fillFilter(filterMap, (Filter)mapFilter);
                    this.getFilters().add(mapFilter);
                    ++i;
                    continue;
                }
                completed = true;
            }
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getStepReference() {
        return this.stepReference;
    }

    public void setStepReference(String stepReference) {
        this.stepReference = stepReference;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Set<Filter> getFiltersList() {
        return this.filtersList;
    }

    public void setFiltersList(Set<Filter> filtersList) {
        this.filtersList = filtersList;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }
}

