/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.AddField;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesEnum;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Field
implements Comparable<Field> {
    @JsonProperty(value="isInput")
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private boolean isInput;
    @JsonProperty(value="required")
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private boolean required;
    @JsonProperty(value="variableName")
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private String name;
    @JsonProperty(value="superLabel")
    private String superLabel;
    @JsonProperty(value="isFieldSet")
    @JsonSerialize(include=JsonSerialize.Inclusion.ALWAYS)
    private boolean isFieldSet;
    @JsonProperty(value="nestedGlobalVariablesReferences")
    private List<Field> fields;
    @JsonIgnore
    private VariableTypesEnum type;
    @JsonIgnore
    private String label;
    @JsonIgnore
    private String value;
    @JsonIgnore
    private String varOptions;
    @JsonProperty(value="path")
    private String path;
    @JsonProperty(value="helpText")
    private String helpText;

    public Field() {
    }

    public Field(PropertyMap propertyMap, Map<String, Variable> variables) {
        this.setInput(propertyMap.getBoolean("isInput").booleanValue());
        this.setRequired(propertyMap.getBoolean("required").booleanValue());
        this.setSuperLabel(propertyMap.getString("superLabel"));
        this.setFieldSet(BooleanUtils.isTrue((Boolean)propertyMap.getBoolean("isFieldSet")));
        this.setPath(propertyMap.getString("path"));
        this.setHelpText(propertyMap.getString("helpText"));
        Variable variable = variables.get(propertyMap.getString("variableName"));
        if (variable != null) {
            this.setName(variable.getName());
            this.setLabel(variable.getLabel());
            this.setType(variable.getType());
            this.setVarOptions(variable.getVarOptions());
        }
    }

    public Field(String path, AddField addField, boolean isFieldSet) {
        this.setPath(path);
        this.setInput(addField.isInput());
        this.setRequired(addField.isRequired());
        this.setSuperLabel(addField.getLabel());
        this.setFieldSet(isFieldSet);
        this.setName(addField.getVariableName());
        this.setLabel(addField.getLabel());
        this.setType(addField.getType());
        this.setVarOptions(addField.getVarOptions());
        this.setHelpText(addField.getHelpText());
    }

    public boolean isInput() {
        return this.isInput;
    }

    public void setInput(boolean isInput) {
        this.isInput = isInput;
    }

    @Override
    public int compareTo(Field field) {
        boolean deeperComparedPath;
        int index = 0;
        String[] pathArray = StringUtils.split((String)this.getPath(), (char)',');
        String[] comparedPathArray = StringUtils.split((String)field.getPath(), (char)',');
        Integer pathPart = Integer.parseInt(pathArray[index]);
        Integer comparedPathPart = Integer.parseInt(comparedPathArray[index]);
        int returnValue = pathPart.compareTo(comparedPathPart);
        boolean deeperPath = pathArray.length > index + 1;
        boolean bl = deeperComparedPath = comparedPathArray.length > index + 1;
        if (returnValue == 0 && (deeperPath || deeperComparedPath)) {
            returnValue = deeperPath && !deeperComparedPath ? 1 : (!deeperPath && deeperComparedPath ? -1 : this.compare(pathArray, comparedPathArray, ++index));
        }
        return returnValue;
    }

    private int compare(String[] pathArray, String[] comparedPathArray, int index) {
        boolean deeperComparedPath;
        Integer pathPart = Integer.parseInt(pathArray[index]);
        Integer comparedPathPart = Integer.parseInt(comparedPathArray[index]);
        int returnValue = pathPart.compareTo(comparedPathPart);
        boolean deeperPath = pathArray.length > index + 1;
        boolean bl = deeperComparedPath = comparedPathArray.length > index + 1;
        if (returnValue == 0 && (deeperPath || deeperComparedPath)) {
            returnValue = deeperPath && !deeperComparedPath ? 1 : (!deeperPath && deeperComparedPath ? -1 : this.compare(pathArray, comparedPathArray, ++index));
        }
        return returnValue;
    }

    public boolean isDeletable() {
        return !StringUtils.equals((String)"_title", (String)this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public VariableTypesEnum getType() {
        return this.type;
    }

    public void setType(VariableTypesEnum type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getSuperLabel() {
        return this.superLabel;
    }

    public void setSuperLabel(String superLabel) {
        this.superLabel = superLabel;
    }

    public boolean isFieldSet() {
        return this.isFieldSet;
    }

    public void setFieldSet(boolean isFieldSet) {
        this.isFieldSet = isFieldSet;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public String getVarOptions() {
        return this.varOptions;
    }

    public void setVarOptions(String varOptions) {
        this.varOptions = varOptions;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

