/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.model;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.procedure.portlet.model.Argument;

@JsonAutoDetect(isGetterVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE)
public class Filter
implements Comparable<Filter> {
    @JsonProperty(value="filterName")
    private String filterName;
    @JsonProperty(value="filterPath")
    private String filterPath;
    @JsonProperty(value="filterInstanceId")
    private String filterInstanceId;
    @JsonProperty(value="filterId")
    private String filterId;
    @JsonProperty(value="argumentsList")
    private List<Argument> argumentsList;
    @JsonIgnore
    private boolean hasChildren;
    @JsonIgnore
    private List<Filter> filters;
    @JsonIgnore
    private String labelKey;
    @JsonIgnore
    private String descriptionKey;
    @JsonIgnore
    private ClassLoader classLoader;

    public Filter() {
    }

    public Filter(FormFilter formFilter, String path) {
        this.setFilterPath(path);
        this.setFilterId(formFilter.getId());
        this.setFilterInstanceId(this.getFilterId().concat(this.getFilterPath()));
        this.setHasChildren(formFilter.hasChildren());
        this.setLabelKey(formFilter.getLabelKey());
        this.setDescriptionKey(formFilter.getDescriptionKey());
        this.setClassLoader(formFilter.getClass().getClassLoader());
        if (formFilter.getParameters() != null) {
            ArrayList<Argument> argumentsList = new ArrayList<Argument>(formFilter.getParameters().entrySet().size());
            for (Map.Entry argumentEntry : formFilter.getParameters().entrySet()) {
                Argument argument = new Argument();
                argument.setArgumentName((String)argumentEntry.getKey());
                argument.setType((FormFilterParameterType)argumentEntry.getValue());
                argumentsList.add(argument);
            }
            this.setArgumentsList(argumentsList);
        }
    }

    public Filter(PropertyMap propertyMap, NuxeoController nuxeoController) {
        PropertyList argumentsPptyList;
        this.setFilterName(propertyMap.getString("filterName"));
        this.setFilterPath(propertyMap.getString("filterPath"));
        this.setFilterId(propertyMap.getString("filterId"));
        this.setFilterInstanceId(propertyMap.getString("filterInstanceId"));
        Map formsFilters = nuxeoController.getNuxeoCMSService().getCMSCustomizer().getFormsFilters();
        FormFilter formFilter = (FormFilter)formsFilters.get(this.getFilterId());
        if (formFilter != null) {
            this.setLabelKey(formFilter.getLabelKey());
            this.setDescriptionKey(formFilter.getDescriptionKey());
            this.setHasChildren(formFilter.hasChildren());
            this.setClassLoader(formFilter.getClass().getClassLoader());
        }
        if ((argumentsPptyList = propertyMap.getList("argumentsList")) != null) {
            ArrayList<Argument> argumentsList = new ArrayList<Argument>();
            for (Object argumentO : argumentsPptyList.list()) {
                PropertyMap argumentMap = (PropertyMap)argumentO;
                argumentsList.add(new Argument(argumentMap));
            }
            this.setArgumentsList(argumentsList);
        }
    }

    public void updateFilter(Filter filter) {
        this.setFilterName(filter.getFilterName());
        this.setArgumentsList(filter.getArgumentsList());
    }

    public void updateFilterPath(String newPath) {
        this.setFilterPath(newPath);
        this.setFilterInstanceId(this.getFilterId().concat(this.getFilterPath()));
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public void setFilterPath(String filterPath) {
        this.filterPath = filterPath;
    }

    public List<Argument> getArgumentsList() {
        return this.argumentsList;
    }

    public void setArgumentsList(List<Argument> argumentsList) {
        this.argumentsList = argumentsList;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public void setFilterId(String filterId) {
        this.filterId = filterId;
    }

    @Override
    public int compareTo(Filter filter) {
        boolean deeperComparedPath;
        int index = 0;
        String[] pathArray = StringUtils.split((String)this.getFilterPath(), (char)',');
        String[] comparedPathArray = StringUtils.split((String)filter.getFilterPath(), (char)',');
        Integer pathPart = Integer.parseInt(pathArray[index]);
        Integer comparedPathPart = Integer.parseInt(comparedPathArray[index]);
        int returnValue = pathPart.compareTo(comparedPathPart);
        boolean deeperPath = pathArray.length > index + 1;
        boolean bl = deeperComparedPath = comparedPathArray.length > index + 1;
        if (returnValue == 0 && (deeperPath || deeperComparedPath)) {
            returnValue = deeperPath && !deeperComparedPath ? 1 : (!deeperPath && deeperComparedPath ? -1 : this.compare(pathArray, comparedPathArray, ++index));
        }
        return returnValue;
    }

    private int compare(String[] pathArray, String[] comparedPathArray, int index) {
        boolean deeperComparedPath;
        Integer pathPart = Integer.parseInt(pathArray[index]);
        Integer comparedPathPart = Integer.parseInt(comparedPathArray[index]);
        int returnValue = pathPart.compareTo(comparedPathPart);
        boolean deeperPath = pathArray.length > index + 1;
        boolean bl = deeperComparedPath = comparedPathArray.length > index + 1;
        if (returnValue == 0 && (deeperPath || deeperComparedPath)) {
            returnValue = deeperPath && !deeperComparedPath ? 1 : (!deeperPath && deeperComparedPath ? -1 : this.compare(pathArray, comparedPathArray, ++index));
        }
        return returnValue;
    }

    public String getFilterInstanceId() {
        return this.filterInstanceId;
    }

    public void setFilterInstanceId(String filterInstanceId) {
        this.filterInstanceId = filterInstanceId;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String labelKey) {
        this.labelKey = labelKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

