/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.service.impl;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.procedure.portlet.adapter.ProcedureJSONAdapter;
import org.osivia.services.procedure.portlet.command.CreateDocumentCommand;
import org.osivia.services.procedure.portlet.command.DeleteDocumentCommand;
import org.osivia.services.procedure.portlet.command.ListModelsContainerCommand;
import org.osivia.services.procedure.portlet.command.ListProcedureInstancesByModelListCommand;
import org.osivia.services.procedure.portlet.command.ListProceduresModelsCommand;
import org.osivia.services.procedure.portlet.command.LoadVocabularyCommand;
import org.osivia.services.procedure.portlet.command.RetrieveDocumentByIdCommand;
import org.osivia.services.procedure.portlet.command.RetrieveDocumentByWebIdCommand;
import org.osivia.services.procedure.portlet.command.RetrieveProcedureByStepNameCommand;
import org.osivia.services.procedure.portlet.command.UpdateDocumentCommand;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;
import org.osivia.services.procedure.portlet.model.Field;
import org.osivia.services.procedure.portlet.model.FilePath;
import org.osivia.services.procedure.portlet.model.Form;
import org.osivia.services.procedure.portlet.model.ObjetMetier;
import org.osivia.services.procedure.portlet.model.ProcedureInstance;
import org.osivia.services.procedure.portlet.model.ProcedureModel;
import org.osivia.services.procedure.portlet.model.ProcedureObjectInstance;
import org.osivia.services.procedure.portlet.model.Record;
import org.osivia.services.procedure.portlet.model.Step;
import org.osivia.services.procedure.portlet.model.Variable;
import org.osivia.services.procedure.portlet.model.VariableTypesEnum;
import org.osivia.services.procedure.portlet.model.WebIdException;
import org.osivia.services.procedure.portlet.service.IProcedureService;
import org.osivia.services.procedure.portlet.util.ObjetMetierUtil;
import org.osivia.services.procedure.portlet.util.VocabularySelect2Util;
import org.springframework.stereotype.Service;

@Service
public class ProcedureServiceImpl
implements IProcedureService {
    private static final Pattern WEBID_ERROR = Pattern.compile("WebId: .+ already exists\\.");

    public ProcedureModel createProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel, String procedurepath) throws PortletException, WebIdException {
        try {
            ListModelsContainerCommand command = new ListModelsContainerCommand(procedurepath);
            Document container = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            String webId = StringUtils.isBlank((String)procedureModel.getNewWebId()) ? null : "procedure_" + procedureModel.getNewWebId();
            DocumentTypeEnum type = StringUtils.isNotBlank((String)procedureModel.getProcedureType()) ? DocumentTypeEnum.get((String)procedureModel.getProcedureType()) : DocumentTypeEnum.PROCEDUREMODEL;
            command = new CreateDocumentCommand(container, this.buildProperties(procedureModel), type);
            Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            return new ProcedureModel(procedureModelInstance, nuxeoController);
        }
        catch (NuxeoException e) {
            Throwable rootCause = this.getRootCause((Throwable)e);
            String errorMessage = rootCause.getMessage();
            if (WEBID_ERROR.matcher(errorMessage).matches()) {
                throw new WebIdException();
            }
            throw new PortletException((Throwable)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ProcedureModel retrieveProcedureByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        Document document = null;
        ProcedureModel procedureModel = null;
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(webId);
            document = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            procedureModel = new ProcedureModel(document, nuxeoController);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return procedureModel;
    }

    private Throwable getRootCause(Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public List<ProcedureInstance> retrieveProceduresInstanceByModel(NuxeoController nuxeoController, ProcedureModel procedureModel) {
        ListProcedureInstancesByModelListCommand command = new ListProcedureInstancesByModelListCommand(procedureModel.getPath(), procedureModel.getCurrentWebId(), false);
        Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        ArrayList<ProcedureInstance> procedureInstanceList = new ArrayList<ProcedureInstance>(documents.size());
        for (Document document : documents) {
            ProcedureInstance procedureInstance = new ProcedureInstance(document);
            procedureInstance.setUrl(nuxeoController.getLink(document).getUrl());
            procedureInstanceList.add(procedureInstance);
        }
        return procedureInstanceList;
    }

    public ProcedureModel updateProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException, WebIdException {
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(procedureModel.getCurrentWebId());
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            command = new UpdateDocumentCommand(currentDocument, this.buildProperties(procedureModel));
            Document procedureModelInstance = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            return new ProcedureModel(procedureModelInstance, nuxeoController);
        }
        catch (NuxeoException e) {
            Throwable rootCause = this.getRootCause((Throwable)e);
            String errorMessage = rootCause.getMessage();
            if (WEBID_ERROR.matcher(errorMessage).matches()) {
                throw new WebIdException();
            }
            throw new PortletException((Throwable)e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    private PropertyMap buildProperties(ProcedureModel procedureModel) throws JsonGenerationException, JsonMappingException, IOException {
        String webId;
        PropertyMap propMap = new PropertyMap();
        propMap.set("dc:title", procedureModel.getName());
        String string = webId = StringUtils.isNotBlank((String)procedureModel.getNewWebId()) ? "procedure_" + procedureModel.getNewWebId() : null;
        if (webId != null) {
            propMap.set("ttc:webid", webId);
        }
        propMap.set("pcd:webIdParent", procedureModel.getWebIdParent());
        propMap.set("pcd:steps", ProcedureJSONAdapter.getInstance().toJSON((Object)procedureModel.getSteps()));
        procedureModel.updateVariables();
        propMap.set("pcd:globalVariablesDefinitions", ProcedureJSONAdapter.getInstance().toJSON(procedureModel.getVariables().values()));
        propMap.set("pcd:startingStep", procedureModel.getStartingStep());
        propMap.set("pcd:procedureObjects", ProcedureJSONAdapter.getInstance().toJSON((Object)procedureModel.getProcedureObjects()));
        propMap.set("pcd:dashboards", ProcedureJSONAdapter.getInstance().toJSON((Object)procedureModel.getDashboards()));
        return propMap;
    }

    public void deleteProcedure(NuxeoController nuxeoController, ProcedureModel procedureModel) throws PortletException {
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(procedureModel.getCurrentWebId());
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            command = new DeleteDocumentCommand(currentDocument);
            nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public ProcedureInstance retrieveProcedureInstanceByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        ProcedureInstance procedureInstance = null;
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(webId);
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            procedureInstance = new ProcedureInstance(currentDocument);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return procedureInstance;
    }

    public Record retrieveRecordInstanceByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        Record record = null;
        try {
            RetrieveDocumentByWebIdCommand command = new RetrieveDocumentByWebIdCommand(webId);
            Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
            record = new Record(currentDocument);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        return record;
    }

    public ProcedureInstance retrieveProcedureInstanceById(NuxeoController nuxeoController, String uuid) throws PortletException {
        RetrieveDocumentByIdCommand command = new RetrieveDocumentByIdCommand(uuid);
        Document currentDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
        PropertyMap properties = currentDocument.getProperties();
        PropertyMap procedureInstanceMap = properties.getMap("nt:pi");
        String piWebId = procedureInstanceMap.getString("ttc:webid");
        return this.retrieveProcedureInstanceByWebId(nuxeoController, piWebId);
    }

    public List<ProcedureModel> listProcedures(NuxeoController nuxeoController, String procedurepath) throws PortletException {
        Documents documentList;
        ArrayList<ProcedureModel> procedureModels = new ArrayList<ProcedureModel>();
        try {
            ListModelsContainerCommand command = new ListModelsContainerCommand(procedurepath);
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            if (documentList != null && !documentList.isEmpty()) {
                Document modelsContainer = documentList.get(0);
                command = new ListProceduresModelsCommand(modelsContainer.getPath());
                documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        if (documentList != null && !documentList.isEmpty()) {
            for (Document document : documentList) {
                ProcedureModel procedureModel = new ProcedureModel(document, nuxeoController);
                try {
                    procedureModel.setUrl(this.getEditUrl(nuxeoController, procedureModel, procedurepath));
                }
                catch (PortalException e) {
                    new PortletException((Throwable)e);
                }
                procedureModels.add(procedureModel);
            }
        }
        return procedureModels;
    }

    private String getEditUrl(NuxeoController nuxeoController, ProcedureModel procedureModel, String procedurepath) throws PortalException {
        Map windowProperties = StringUtils.equals((String)procedureModel.getProcedureType(), (String)DocumentTypeEnum.RECORDFOLDER.getDocType()) ? this.getWindowProperties(procedurepath, "adminrecord", procedureModel.getProcedureType()) : this.getWindowProperties(procedurepath, "adminproc", procedureModel.getProcedureType());
        windowProperties.put("osivia.services.procedure.webid", procedureModel.getCurrentWebId());
        windowProperties.put("osivia.title", "\u00c9diter une procedure");
        return nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
    }

    private Map<String, String> getWindowProperties(String procedurePath, String displayContext, String procedureType) throws PortalException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.doctype", procedureType);
        windowProperties.put("osivia.services.procedure.procedurePath", procedurePath);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.procedure.admin", displayContext);
        return windowProperties;
    }

    public String getAddUrl(NuxeoController nuxeoController, String procedurePath, String displayContext, String procedureType) throws PortletException {
        try {
            Map windowProperties = this.getWindowProperties(procedurePath, displayContext, procedureType);
            windowProperties.put("osivia.title", "Cr\u00e9er une procedure");
            return nuxeoController.getPortalUrlFactory().getStartPortletUrl(nuxeoController.getPortalCtx(), "osivia-services-procedure-portletInstance", windowProperties, PortalUrlType.DEFAULT);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
    }

    private void updateFormWithObjectsValues(NuxeoController nuxeoController, Form form) throws PortletException {
        HashMap ojMap = new HashMap();
        for (Field field : form.getTheCurrentStep().getFields()) {
            this.updateFormWithObjectsValues(field, ojMap, nuxeoController, form);
        }
    }

    private void updateFormWithObjectsValues(Field field, Map<String, ObjetMetier> ojMap, NuxeoController nuxeoController, Form form) throws PortletException {
        if (!field.isFieldSet()) {
            if (ObjetMetierUtil.isObject((String)field.getName()) && form.getProcedureInstance().getProcedureObjects().containsKey(ObjetMetierUtil.getObjectName((String)field.getName()))) {
                ObjetMetier objetMetier;
                if (ojMap.containsKey(field.getName())) {
                    objetMetier = ojMap.get(field.getName());
                } else {
                    RetrieveDocumentByWebIdCommand command;
                    try {
                        command = new RetrieveDocumentByWebIdCommand(((ProcedureObjectInstance)form.getProcedureInstance().getProcedureObjects().get(ObjetMetierUtil.getObjectName((String)field.getName()))).getProcedureObjectid());
                    }
                    catch (Exception e) {
                        throw new PortletException((Throwable)e);
                    }
                    Document objetMetierDocument = ((Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command)).get(0);
                    nuxeoController.setDisplayLiveVersion("1");
                    String downloadLink = nuxeoController.createFileLink(objetMetierDocument, "file:content");
                    FilePath filePath = new FilePath();
                    filePath.setDownloadLink(downloadLink);
                    filePath.setFileName(objetMetierDocument.getString("file:filename"));
                    objetMetier = new ObjetMetier(objetMetierDocument, filePath);
                    ojMap.put(field.getName(), objetMetier);
                }
                if (ObjetMetierUtil.isContent((String)field.getName())) {
                    if (form.getProcedureInstance().getFilesPath().containsKey(field.getName())) {
                        ((FilePath)form.getProcedureInstance().getFilesPath().get(field.getName())).setDownloadLink(objetMetier.getFilePath().getDownloadLink());
                    } else {
                        form.getProcedureInstance().getFilesPath().put(field.getName(), objetMetier.getFilePath());
                    }
                } else {
                    form.getProcedureInstance().getGlobalVariablesValues().put(field.getName(), objetMetier.getProperties().getString(ObjetMetierUtil.getObjectProperty((String)field.getName())));
                }
            }
        } else {
            for (Field nestedField : field.getFields()) {
                this.updateFormWithObjectsValues(nestedField, ojMap, nuxeoController, form);
            }
        }
    }

    private void updateVocabulariesWithValues(NuxeoController nuxeoController, Form form) throws PortletException {
        Map variables = form.getProcedureModel().getVariables();
        for (Map.Entry entryV : variables.entrySet()) {
            if (!VariableTypesEnum.CHECKBOXVOCAB.equals((Object)((Variable)entryV.getValue()).getType()) && !VariableTypesEnum.RADIOVOCAB.equals((Object)((Variable)entryV.getValue()).getType())) continue;
            ArrayList varOptions = new ArrayList();
            VocabularyEntry vocabularyEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, (String)((Variable)entryV.getValue()).getVarOptions());
            for (VocabularyEntry entry : vocabularyEntry.getChildren().values()) {
                HashMap<String, String> vocabEntry = new HashMap<String, String>(2);
                vocabEntry.put("label", entry.getLabel());
                vocabEntry.put("value", entry.getId());
                varOptions.add(vocabEntry);
            }
            try {
                ((Variable)entryV.getValue()).setVarOptions(ProcedureJSONAdapter.getInstance().toJSON(varOptions));
            }
            catch (JsonGenerationException e) {
                throw new PortletException((Throwable)e);
            }
            catch (JsonMappingException e) {
                throw new PortletException((Throwable)e);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
    }

    public JSONArray getVocabularyValues(NuxeoController nuxeoController, String filter, String vocabularyName) throws PortletException {
        JSONArray values = new JSONArray();
        LoadVocabularyCommand command = new LoadVocabularyCommand(vocabularyName);
        Object object = nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            try {
                String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
                JSONArray array = JSONArray.fromObject((Object)content);
                values = VocabularySelect2Util.parse((JSONArray)array, (String)filter);
            }
            catch (IOException e) {
                throw new PortletException((Throwable)e);
            }
        }
        return values;
    }

    public String getCloseUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String url;
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        boolean contextualization = "1".equals(window.getProperty("osivia.cms.contextualization"));
        try {
            url = contextualization ? nuxeoController.getPortalUrlFactory().getDestroyCurrentPageUrl(portalControllerContext) : nuxeoController.getPortalUrlFactory().getBackURL(portalControllerContext, false);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return url;
    }

    public List<Map<String, String>> retrieveStepsByName(NuxeoController nuxeoController, String filter) {
        Documents procedures = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new RetrieveProcedureByStepNameCommand(filter));
        ArrayList results = null;
        if (procedures != null) {
            results = new ArrayList(procedures.size());
            HashMap<String, String> stepResult = new HashMap<String, String>(2);
            for (Document document : procedures) {
                ProcedureModel procedureModel = new ProcedureModel(document, nuxeoController);
                for (Step step : procedureModel.getSteps()) {
                    if (!StringUtils.contains((String)step.getStepName(), (String)filter)) continue;
                    stepResult.put("id", step.getReference());
                    stepResult.put("text", step.getStepName());
                    results.add(stepResult);
                }
            }
        }
        return results;
    }

    public List<ProcedureModel> retrieveProcedureModels(NuxeoController nuxeoController, String procedurepath, String filter) throws PortletException {
        ArrayList<ProcedureModel> procedureModels = new ArrayList<ProcedureModel>();
        Documents documentList = null;
        if (StringUtils.isNotBlank((String)filter)) {
            filter = "AND dc:title LIKE '%".concat(filter).concat("%'");
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new ListProceduresModelsCommand(procedurepath, filter));
        } else {
            documentList = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new ListProceduresModelsCommand(procedurepath));
        }
        if (documentList != null) {
            for (Document document : documentList) {
                procedureModels.add(new ProcedureModel(document, nuxeoController));
            }
        }
        return procedureModels;
    }

    public void updateVarsWithOptions(Form form) {
        List fields = form.getTheCurrentStep().getFields();
        for (Field field : fields) {
            this.updateVarWithOptions(form, field);
        }
    }

    private void updateVarWithOptions(Form form, Field field) {
        String variableValue = (String)form.getProcedureInstance().getGlobalVariablesValues().get(field.getName());
        if (!field.isInput() && StringUtils.isNotBlank((String)variableValue)) {
            HashMap<String, String> varOptionsMap = null;
            String varOptions = field.getVarOptions();
            if (StringUtils.isNotBlank((String)varOptions)) {
                varOptions = StringUtils.substringBetween((String)varOptions, (String)"[", (String)"]");
                String[] varOptionT = StringUtils.splitByWholeSeparator((String)varOptions, (String)"},{");
                varOptionsMap = new HashMap<String, String>(varOptionT.length);
                for (int j = 0; j < varOptionT.length; ++j) {
                    String varOption = varOptionT[j];
                    String[] varOptionLV = StringUtils.split((String)varOption, (char)',');
                    if (varOptionLV == null) continue;
                    String varOptionValue = null;
                    String varOptionLabel = null;
                    for (int k = 0; k < varOptionLV.length; ++k) {
                        String varOptionLVS = varOptionLV[k];
                        if (StringUtils.startsWith((String)(varOptionLVS = StringUtils.replaceChars((String)varOptionLVS, (String)"\"{}", (String)"")), (String)"label")) {
                            varOptionLabel = StringUtils.substringAfterLast((String)varOptionLVS, (String)":");
                            continue;
                        }
                        if (!StringUtils.startsWith((String)varOptionLVS, (String)"value")) continue;
                        varOptionValue = StringUtils.substringAfterLast((String)varOptionLVS, (String)":");
                    }
                    if (!StringUtils.isNotBlank(varOptionValue) || !StringUtils.isNotBlank(varOptionLabel)) continue;
                    varOptionsMap.put(varOptionValue, varOptionLabel);
                }
                Object[] values = StringUtils.split((String)variableValue, (char)',');
                if (ArrayUtils.isNotEmpty((Object[])values)) {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = varOptionsMap.get(values[i]) != null ? (String)varOptionsMap.get(values[i]) : values[i];
                    }
                }
                variableValue = StringUtils.join((Object[])values, (char)',');
                form.getProcedureInstance().getGlobalVariablesValues().put(field.getName(), variableValue);
            }
        }
    }

    public void updateData(NuxeoController nuxeoController, Form form) throws PortletException {
        this.updateFormWithObjectsValues(nuxeoController, form);
        this.updateVocabulariesWithValues(nuxeoController, form);
        this.updateVarsWithOptions(form);
    }
}

