/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.osivia.services.procedure.portlet.util.VocabularySelect2Util;

/*
 * Exception performing whole class analysis ignored.
 */
public class VocabularySelect2Util {
    public static JSONArray parse(JSONArray array, String filter) throws IOException {
        HashMap<String, Item> items = new HashMap<String, Item>(array.size());
        LinkedHashSet<String> rootItems = new LinkedHashSet<String>();
        boolean multilevel = false;
        for (JSONObject object : array) {
            String key = object.getString("key");
            String value = object.getString("value");
            String parent = null;
            if (object.containsKey((Object)"parent")) {
                parent = object.getString("parent");
            }
            boolean matches = StringUtils.isBlank((String)filter) ? true : VocabularySelect2Util.matches((String)value, (String)filter);
            Item item = (Item)items.get(key);
            if (item == null) {
                item = new Item(key);
                items.put(key, item);
            }
            Item.access$002((Item)item, (String)value);
            Item.access$102((Item)item, (String)parent);
            if (matches) {
                Item.access$202((Item)item, (boolean)true);
                Item.access$302((Item)item, (boolean)true);
            }
            if (StringUtils.isEmpty((String)parent)) {
                rootItems.add(key);
                continue;
            }
            multilevel = true;
            Item parentItem = (Item)items.get(parent);
            if (parentItem == null) {
                parentItem = new Item(parent);
                items.put(parent, parentItem);
            }
            Item.access$400((Item)parentItem).add(key);
            if (!Item.access$300((Item)item)) continue;
            while (parentItem != null) {
                Item.access$302((Item)parentItem, (boolean)true);
                if (StringUtils.isEmpty((String)Item.access$100((Item)parentItem))) {
                    parentItem = null;
                    continue;
                }
                parentItem = (Item)items.get(Item.access$100((Item)parentItem));
            }
        }
        JSONArray results = new JSONArray();
        VocabularySelect2Util.generateChildren(items, (JSONArray)results, rootItems, (boolean)multilevel, (int)1, null);
        return results;
    }

    private static boolean matches(String value, String filter) throws UnsupportedEncodingException {
        boolean matches = true;
        if (filter != null) {
            String[] splittedFilters;
            String decodedValue = URLDecoder.decode(value, "UTF-8");
            String diacriticalValue = Normalizer.normalize(decodedValue, Normalizer.Form.NFD).replaceAll("\\p{IsM}+", "");
            for (String splittedFilter : splittedFilters = StringUtils.split((String)filter, (String)"*")) {
                String diacriticalFilter = Normalizer.normalize(splittedFilter, Normalizer.Form.NFD).replaceAll("\\p{IsM}+", "");
                if (StringUtils.containsIgnoreCase((String)diacriticalValue, (String)diacriticalFilter)) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    private static void generateChildren(Map<String, Item> items, JSONArray array, Set<String> children, boolean optgroup, int level, String parentId) throws UnsupportedEncodingException {
        for (String child : children) {
            Item item = items.get(child);
            if (item == null || !Item.access$300((Item)item)) continue;
            String id = parentId == null ? Item.access$500((Item)item) : parentId + "/" + Item.access$500((Item)item);
            JSONObject object = new JSONObject();
            object.put((Object)"id", (Object)id);
            object.put((Object)"text", (Object)URLDecoder.decode(Item.access$000((Item)item), "UTF-8"));
            object.put((Object)"optgroup", (Object)optgroup);
            object.put((Object)"level", (Object)level);
            if (!Item.access$200((Item)item)) {
                object.put((Object)"disabled", (Object)true);
            }
            array.add((Object)object);
            if (Item.access$400((Item)item).isEmpty()) continue;
            VocabularySelect2Util.generateChildren(items, (JSONArray)array, (Set)Item.access$400((Item)item), (boolean)false, (int)(level + 1), (String)id);
        }
    }
}

