/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.plugin;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoPublicationInfos;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.plugin.PluginModule;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.player.Player;
import org.osivia.services.procedure.portlet.model.DocumentTypeEnum;

public class ProcedurePlayer
extends PluginModule
implements INuxeoPlayerModule {
    private static final String PROCEDURE_MODEL_ID_WINDOW_PROPERTY = "osivia.forms.list.model.id";

    public ProcedurePlayer(PortletContext portletContext) {
        super(portletContext);
    }

    private Player getProcedureInstancePlayer(NuxeoDocumentContext docCtx) {
        Document document = docCtx.getDocument();
        String displayContext = docCtx.getDisplayContext();
        Map windowProperties = this.getProcedureWindowProperties(document);
        windowProperties.put("osivia.title", document.getTitle());
        windowProperties.put("osivia.procedure.admin", displayContext);
        Player linkProps = this.getProcedurePlayer(windowProperties);
        return linkProps;
    }

    private Player getTaskPlayer(NuxeoDocumentContext docCtx) {
        Document document = docCtx.getDocument();
        PropertyMap docProperties = document.getProperties();
        String displayContext = docCtx.getDisplayContext();
        Map windowProperties = this.getProcedureWindowProperties(document);
        windowProperties.put("osivia.title", docProperties.getString("nt:name"));
        windowProperties.put("osivia.procedure.admin", displayContext);
        Player linkProps = this.getProcedurePlayer(windowProperties);
        return linkProps;
    }

    private Map<String, String> getProcedureWindowProperties(Document document) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        String webid = document.getProperties().getString("ttc:webid");
        windowProperties.put("osivia.services.procedure.webid", webid);
        windowProperties.put(PROCEDURE_MODEL_ID_WINDOW_PROPERTY, webid);
        windowProperties.put("osivia.services.procedure.uuid", document.getId());
        windowProperties.put("osivia.doctype", document.getType());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "true");
        windowProperties.put("osivia.ajaxLink", "1");
        return windowProperties;
    }

    private Player getProcedureModelPlayer(NuxeoDocumentContext docCtx) {
        Document document = docCtx.getDocument();
        String displayContext = docCtx.getDisplayContext();
        Map windowProperties = this.getProcedureWindowProperties(document);
        if (StringUtils.equals((String)displayContext, (String)"adminproc") || StringUtils.equals((String)displayContext, (String)"adminprocstep")) {
            windowProperties.put("osivia.procedure.admin", displayContext);
            windowProperties.put("osivia.title", "\u00c9diter une proc\u00e9dure");
            return this.getProcedurePlayer(windowProperties);
        }
        windowProperties.put("osivia.title", document.getTitle());
        return this.getProcedurePlayer(windowProperties);
    }

    private Player getProcedurePlayer(Map<String, String> windowProperties) {
        Player player = new Player();
        player.setWindowProperties(windowProperties);
        player.setPortletInstance("osivia-services-procedure-portletInstance");
        return player;
    }

    private Player getRecordFolderPlayer(NuxeoDocumentContext docCtx) {
        Player player = null;
        if (docCtx.getDocument() != null) {
            player = new Player();
            HashMap<String, String> windowProperties = new HashMap<String, String>();
            windowProperties.put("osivia.title", docCtx.getDocument().getTitle());
            String displayContext = docCtx.getDisplayContext();
            windowProperties.putAll(this.getProcedureWindowProperties(docCtx.getDocument()));
            if (!StringUtils.equals((String)displayContext, (String)"menu") && !StringUtils.equals((String)displayContext, (String)"breadcrumb")) {
                windowProperties.put("osivia.procedure.admin", displayContext);
                player.setWindowProperties(windowProperties);
                player.setPortletInstance("osivia-services-procedure-portletInstance");
            } else {
                windowProperties.put("osivia.cms.displayLiveVersion", "1");
                player.setWindowProperties(windowProperties);
                player.setPortletInstance("toutatice-portail-cms-nuxeo-viewProcedurePortletInstance");
            }
        }
        return player;
    }

    private Player getRecordPlayer(NuxeoDocumentContext docCtx) {
        Player player = null;
        Document document = docCtx.getDocument();
        if (document != null) {
            player = new Player();
            HashMap<String, String> windowProperties = new HashMap<String, String>();
            windowProperties.put("osivia.title", document.getTitle());
            windowProperties.putAll(this.getProcedureWindowProperties(document));
            windowProperties.put("osivia.procedure.admin", docCtx.getDisplayContext());
            player.setWindowProperties(windowProperties);
            player.setPortletInstance("osivia-services-procedure-portletInstance");
        }
        return player;
    }

    private Player getRecordContainerPlayer(NuxeoDocumentContext docCtx) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(docCtx));
        windowProperties.put("osivia.cms.style", "containerlist");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", docCtx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", docCtx.getDocumentState().toString());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", docCtx.getDocument().getTitle());
        windowProperties.put("osivia.createParentPath", docCtx.getDocument().getPath());
        Player player = new Player();
        player.setWindowProperties(windowProperties);
        player.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return player;
    }

    private String createFolderRequest(NuxeoDocumentContext docCtx) {
        StringBuilder nuxeoRequestSb = new StringBuilder();
        Document document = docCtx.getDocument();
        NuxeoPublicationInfos publicationInfos = docCtx.getPublicationInfos();
        if (docCtx.isContextualized()) {
            nuxeoRequestSb.append("ecm:parentId = '");
            nuxeoRequestSb.append(publicationInfos.getLiveId());
        } else {
            nuxeoRequestSb.append("ecm:path STARTSWITH '");
            nuxeoRequestSb.append(NuxeoController.getLivePath((String)document.getPath()));
        }
        nuxeoRequestSb.append("' order by dc:modified desc");
        return nuxeoRequestSb.toString();
    }

    public Player getCMSPlayer(NuxeoDocumentContext docCtx) {
        Document doc = docCtx.getDocument();
        String docType = doc.getType();
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.PROCEDUREINSTANCE.getDocType())) {
            return this.getProcedureInstancePlayer(docCtx);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.PROCEDUREMODEL.getDocType())) {
            return this.getProcedureModelPlayer(docCtx);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.TASKDOC.getDocType())) {
            return this.getTaskPlayer(docCtx);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.RECORDFOLDER.getDocType())) {
            return this.getRecordFolderPlayer(docCtx);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.RECORD.getDocType())) {
            return this.getRecordPlayer(docCtx);
        }
        if (StringUtils.equals((String)docType, (String)DocumentTypeEnum.RECORDCONTAINER.getDocType())) {
            return this.getRecordContainerPlayer(docCtx);
        }
        return null;
    }
}

