/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.procedure.portlet.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.osivia.services.procedure.portlet.model.NuxeoOperationEnum;

public class ListProceduresModelsCommand
implements INuxeoCommand {
    private static final String SELECT = "SELECT * FROM ProcedureModel, RecordFolder";
    private static final String WHERE = " WHERE ";
    private static final String CLAUSE_BEGIN = " ecm:path STARTSWITH '";
    private static final String CLAUSE_END = "' ";
    private static final String ORDER = " ORDER BY dc:title";
    private final String path;
    private final String filter;

    public ListProceduresModelsCommand(String path) {
        this(path, null);
    }

    public ListProceduresModelsCommand(String path, String filter) {
        this.path = path;
        this.filter = filter;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest(NuxeoOperationEnum.QueryElasticSearch.getId());
        StringBuilder query = new StringBuilder(SELECT);
        if (StringUtils.isNotBlank((String)this.path)) {
            query.append(WHERE);
            StringBuilder clause = new StringBuilder();
            clause.append(CLAUSE_BEGIN);
            clause.append(this.path);
            clause.append(CLAUSE_END);
            if (StringUtils.isNotBlank((String)this.filter)) {
                clause.append(this.filter);
            }
            clause.append(ORDER);
            String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, (String)clause.toString());
            query.append(filteredClause);
        }
        request.set("query", (Object)query.toString());
        return request.execute();
    }

    public String getId() {
        return "ListProceduresModelsCommand/" + this.path;
    }
}

